/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.http.dispatcher;

import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferCompletionMessage;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferProcessAck;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferRequestMessage;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferStartMessage;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferSuspensionMessage;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferTerminationMessage;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.protocol.dsp.http.dispatcher.PostDspHttpRequestFactory;
import org.eclipse.edc.protocol.dsp.http.serialization.JsonLdResponseBodyDeserializer;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.DspHttpRemoteMessageDispatcher;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.DspHttpRequestFactory;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.response.DspHttpResponseBodyExtractor;
import org.eclipse.edc.protocol.dsp.http.spi.serialization.JsonLdRemoteMessageSerializer;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;

@Extension(value="Dataspace Protocol Transfer HTTP Dispatcher Extension")
public class DspTransferProcessDispatcherExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Transfer HTTP Dispatcher Extension";
    @Inject
    private DspHttpRemoteMessageDispatcher messageDispatcher;
    @Inject
    private JsonLdRemoteMessageSerializer remoteMessageSerializer;
    @Inject
    private TypeManager typeManager;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private JsonLd jsonLd;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.messageDispatcher.registerMessage(TransferRequestMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, m -> "/transfers/request"), (DspHttpResponseBodyExtractor)new JsonLdResponseBodyDeserializer(TransferProcessAck.class, this.typeManager.getMapper("json-ld"), this.jsonLd, this.transformerRegistry.forContext("dsp-api")));
        this.messageDispatcher.registerMessage(TransferCompletionMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, m -> "/transfers/" + m.getProcessId() + "/completion"), DspHttpResponseBodyExtractor.NOOP);
        this.messageDispatcher.registerMessage(TransferStartMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, m -> "/transfers/" + m.getProcessId() + "/start"), DspHttpResponseBodyExtractor.NOOP);
        this.messageDispatcher.registerMessage(TransferSuspensionMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, m -> "/transfers/" + m.getProcessId() + "/suspension"), DspHttpResponseBodyExtractor.NOOP);
        this.messageDispatcher.registerMessage(TransferTerminationMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, m -> "/transfers/" + m.getProcessId() + "/termination"), DspHttpResponseBodyExtractor.NOOP);
    }
}

