/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.http.api.controller;

import jakarta.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import org.eclipse.edc.connector.controlplane.services.spi.transferprocess.TransferProcessProtocolService;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferCompletionMessage;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferError;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferRequestMessage;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferStartMessage;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferSuspensionMessage;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferTerminationMessage;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.protocol.dsp.http.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.http.spi.message.GetDspRequest;
import org.eclipse.edc.protocol.dsp.http.spi.message.PostDspRequest;

public abstract class BaseDspTransferProcessApiController {
    private final TransferProcessProtocolService protocolService;
    private final DspRequestHandler dspRequestHandler;
    private final String protocol;
    private final JsonLdNamespace namespace;

    public BaseDspTransferProcessApiController(TransferProcessProtocolService protocolService, DspRequestHandler dspRequestHandler, String protocol, JsonLdNamespace namespace) {
        this.protocolService = protocolService;
        this.dspRequestHandler = dspRequestHandler;
        this.protocol = protocol;
        this.namespace = namespace;
    }

    @GET
    @Path(value="/{id}")
    public Response getTransferProcess(@PathParam(value="id") String id, @HeaderParam(value="Authorization") String token) {
        GetDspRequest request = (GetDspRequest)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)GetDspRequest.Builder.newInstance(TransferProcess.class, TransferError.class).id(id).token(token)).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).findById(arg_0, arg_1))).protocol(this.protocol)).errorProvider(TransferError.Builder::newInstance)).build();
        return this.dspRequestHandler.getResource(request);
    }

    @POST
    @Path(value="request")
    public Response initiateTransferProcess(JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(TransferRequestMessage.class, TransferProcess.class, TransferError.class).message(jsonObject).token(token)).expectedMessageType(this.namespace.toIri("TransferRequestMessage")).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyRequested(arg_0, arg_1))).errorProvider(TransferError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.createResource(request);
    }

    @POST
    @Path(value="{id}/start")
    public Response transferProcessStart(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(TransferStartMessage.class, TransferProcess.class, TransferError.class).processId(id).expectedMessageType(this.namespace.toIri("TransferStartMessage")).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyStarted(arg_0, arg_1))).errorProvider(TransferError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/completion")
    public Response transferProcessCompletion(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(TransferCompletionMessage.class, TransferProcess.class, TransferError.class).processId(id).expectedMessageType(this.namespace.toIri("TransferCompletionMessage")).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyCompleted(arg_0, arg_1))).errorProvider(TransferError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/termination")
    public Response transferProcessTermination(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(TransferTerminationMessage.class, TransferProcess.class, TransferError.class).processId(id).expectedMessageType(this.namespace.toIri("TransferTerminationMessage")).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyTerminated(arg_0, arg_1))).errorProvider(TransferError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/suspension")
    public Response transferProcessSuspension(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(TransferSuspensionMessage.class, TransferProcess.class, TransferError.class).processId(id).expectedMessageType(this.namespace.toIri("TransferSuspensionMessage")).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifySuspended(arg_0, arg_1))).errorProvider(TransferError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.updateResource(request);
    }
}

