/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.api.controller;

import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.edc.connector.spi.transferprocess.TransferProcessProtocolService;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferCompletionMessage;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferRequestMessage;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferStartMessage;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferTerminationMessage;
import org.eclipse.edc.protocol.dsp.spi.error.DspErrorResponse;
import org.eclipse.edc.protocol.dsp.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.spi.message.GetDspRequest;
import org.eclipse.edc.protocol.dsp.spi.message.PostDspRequest;
import org.jetbrains.annotations.NotNull;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/transfers/")
public class DspTransferProcessApiController {
    private final TransferProcessProtocolService protocolService;
    private final DspRequestHandler dspRequestHandler;

    public DspTransferProcessApiController(TransferProcessProtocolService protocolService, DspRequestHandler dspRequestHandler) {
        this.protocolService = protocolService;
        this.dspRequestHandler = dspRequestHandler;
    }

    @GET
    @Path(value="/{id}")
    public Response getTransferProcess(@PathParam(value="id") String id, @HeaderParam(value="Authorization") String token) {
        GetDspRequest request = (GetDspRequest)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)GetDspRequest.Builder.newInstance(TransferProcess.class).id(id).token(token)).errorType("https://w3id.org/dspace/v0.8/TransferError")).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).findById(arg_0, arg_1))).build();
        return this.dspRequestHandler.getResource(request);
    }

    @POST
    @Path(value="request")
    public Response initiateTransferProcess(JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(TransferRequestMessage.class, TransferProcess.class).message(jsonObject).token(token)).expectedMessageType("https://w3id.org/dspace/v0.8/TransferRequestMessage").serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyRequested(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/TransferError")).build();
        return this.dspRequestHandler.createResource(request);
    }

    @POST
    @Path(value="{id}/start")
    public Response transferProcessStart(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(TransferStartMessage.class, TransferProcess.class).processId(id).expectedMessageType("https://w3id.org/dspace/v0.8/TransferStartMessage").message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyStarted(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/TransferError")).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/completion")
    public Response transferProcessCompletion(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(TransferCompletionMessage.class, TransferProcess.class).processId(id).expectedMessageType("https://w3id.org/dspace/v0.8/TransferCompletionMessage").message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyCompleted(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/TransferError")).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/termination")
    public Response transferProcessTermination(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(TransferTerminationMessage.class, TransferProcess.class).processId(id).expectedMessageType("https://w3id.org/dspace/v0.8/TransferTerminationMessage").message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyTerminated(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/TransferError")).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/suspension")
    public Response transferProcessSuspension(@PathParam(value="id") String id) {
        return DspTransferProcessApiController.error().processId(id).notImplemented();
    }

    @NotNull
    private static DspErrorResponse error() {
        return DspErrorResponse.type((String)"https://w3id.org/dspace/v0.8/TransferError");
    }
}

