/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.api;

import org.eclipse.edc.connector.spi.transferprocess.TransferProcessProtocolService;
import org.eclipse.edc.protocol.dsp.api.configuration.DspApiConfiguration;
import org.eclipse.edc.protocol.dsp.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.transferprocess.api.controller.DspTransferProcessApiController;
import org.eclipse.edc.protocol.dsp.transferprocess.api.validation.TransferCompletionMessageValidator;
import org.eclipse.edc.protocol.dsp.transferprocess.api.validation.TransferRequestMessageValidator;
import org.eclipse.edc.protocol.dsp.transferprocess.api.validation.TransferStartMessageValidator;
import org.eclipse.edc.protocol.dsp.transferprocess.api.validation.TransferTerminationMessageValidator;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Dataspace Protocol: TransferProcess API Extension")
public class DspTransferProcessApiExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol: TransferProcess API Extension";
    @Inject
    private DspApiConfiguration config;
    @Inject
    private WebService webService;
    @Inject
    private TransferProcessProtocolService transferProcessProtocolService;
    @Inject
    private DspRequestHandler dspRequestHandler;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;

    public void initialize(ServiceExtensionContext context) {
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/TransferRequestMessage", TransferRequestMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/TransferStartMessage", TransferStartMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/TransferCompletionMessage", TransferCompletionMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/TransferTerminationMessage", TransferTerminationMessageValidator.instance());
        DspTransferProcessApiController controller = new DspTransferProcessApiController(this.transferProcessProtocolService, this.dspRequestHandler);
        this.webService.registerResource(this.config.getContextAlias(), (Object)controller);
    }
}

