/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.api.controller;

import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.eclipse.edc.connector.spi.transferprocess.TransferProcessProtocolService;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferCompletionMessage;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferRemoteMessage;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferRequestMessage;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferStartMessage;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferTerminationMessage;
import org.eclipse.edc.jsonld.spi.TypeUtil;
import org.eclipse.edc.protocol.dsp.api.configuration.error.DspErrorResponse;
import org.eclipse.edc.protocol.dsp.transferprocess.api.controller.MessageSpec;
import org.eclipse.edc.service.spi.result.ServiceFailure;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.iam.IdentityService;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.jetbrains.annotations.NotNull;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/transfers/")
public class DspTransferProcessApiController {
    private final Monitor monitor;
    private final TypeTransformerRegistry registry;
    private final TransferProcessProtocolService protocolService;
    private final IdentityService identityService;
    private final String dspCallbackAddress;

    public DspTransferProcessApiController(Monitor monitor, TypeTransformerRegistry registry, TransferProcessProtocolService protocolService, IdentityService identityService, String dspCallbackAddress) {
        this.monitor = monitor;
        this.protocolService = protocolService;
        this.registry = registry;
        this.identityService = identityService;
        this.dspCallbackAddress = dspCallbackAddress;
    }

    @GET
    @Path(value="/{id}")
    public Response getTransferProcess(@PathParam(value="id") String id, @HeaderParam(value="Authorization") String token) {
        Result<ClaimToken> claimTokenResult = this.checkAuthToken(token);
        if (claimTokenResult.failed()) {
            return DspTransferProcessApiController.error().processId(id).unauthorized();
        }
        return (Response)this.protocolService.findById(id, (ClaimToken)claimTokenResult.getContent()).map(this::createTransferProcessResponse).orElse(this.createErrorResponse(id));
    }

    @POST
    @Path(value="request")
    public Response initiateTransferProcess(JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        ServiceResult<TransferProcess> transferProcessResult = this.handleMessage(MessageSpec.Builder.newInstance(TransferRequestMessage.class).expectedMessageType("https://w3id.org/dspace/v0.8/TransferRequestMessage").message(jsonObject).token(token).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyRequested(arg_0, arg_1)).build());
        if (transferProcessResult.failed()) {
            return DspTransferProcessApiController.error().from((ServiceFailure)transferProcessResult.getFailure());
        }
        return this.createTransferProcessResponse((TransferProcess)transferProcessResult.getContent());
    }

    @POST
    @Path(value="{id}/start")
    public Response transferProcessStart(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        return (Response)this.handleMessage(MessageSpec.Builder.newInstance(TransferStartMessage.class).processId(id).expectedMessageType("https://w3id.org/dspace/v0.8/TransferStartMessage").message(jsonObject).token(token).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyStarted(arg_0, arg_1)).build()).map(tp -> Response.ok().build()).orElse(this.createErrorResponse(id));
    }

    @POST
    @Path(value="{id}/completion")
    public Response transferProcessCompletion(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        return (Response)this.handleMessage(MessageSpec.Builder.newInstance(TransferCompletionMessage.class).processId(id).expectedMessageType("https://w3id.org/dspace/v0.8/TransferCompletionMessage").message(jsonObject).token(token).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyCompleted(arg_0, arg_1)).build()).map(tp -> Response.ok().build()).orElse(this.createErrorResponse(id));
    }

    @POST
    @Path(value="{id}/termination")
    public Response transferProcessTermination(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        return (Response)this.handleMessage(MessageSpec.Builder.newInstance(TransferTerminationMessage.class).processId(id).expectedMessageType("https://w3id.org/dspace/v0.8/TransferTerminationMessage").message(jsonObject).token(token).serviceCall((arg_0, arg_1) -> ((TransferProcessProtocolService)this.protocolService).notifyTerminated(arg_0, arg_1)).build()).map(tp -> Response.ok().build()).orElse(this.createErrorResponse(id));
    }

    @POST
    @Path(value="{id}/suspension")
    public Response transferProcessSuspension(@PathParam(value="id") String id) {
        return DspTransferProcessApiController.error().processId(id).notImplemented();
    }

    @NotNull
    private Function<ServiceFailure, Response> createErrorResponse(String id) {
        return failure -> DspTransferProcessApiController.error().processId(id).from(failure);
    }

    private <M extends TransferRemoteMessage> ServiceResult<TransferProcess> handleMessage(MessageSpec<M> messageSpec) {
        this.monitor.debug(() -> String.format("DSP: Incoming %s for transfer process%s", messageSpec.getMessageClass().getSimpleName(), messageSpec.getProcessId() != null ? ": " + messageSpec.getProcessId() : ""), new Throwable[0]);
        Result<ClaimToken> claimToken = this.checkAuthToken(messageSpec.getToken());
        if (claimToken.failed()) {
            return ServiceResult.unauthorized((List)claimToken.getFailureMessages());
        }
        if (!TypeUtil.isOfExpectedType((JsonObject)messageSpec.getMessage(), (String)messageSpec.getExpectedMessageType())) {
            return ServiceResult.badRequest((String[])new String[]{String.format("Request body was not of expected type: %s", messageSpec.getExpectedMessageType())});
        }
        Result ingressResult = (Result)this.registry.transform((Object)messageSpec.getMessage(), messageSpec.getMessageClass()).compose(m -> {
            m.setProtocol("dataspace-protocol-http");
            return this.validateProcessId(messageSpec, m);
        });
        if (ingressResult.failed()) {
            return ServiceResult.badRequest((String[])new String[]{String.format("Failed to read request body: %s", ingressResult.getFailureDetail())});
        }
        return messageSpec.getServiceCall().apply((TransferRemoteMessage)ingressResult.getContent(), (ClaimToken)claimToken.getContent());
    }

    private Result<ClaimToken> checkAuthToken(String token) {
        TokenRepresentation tokenRepresentation = TokenRepresentation.Builder.newInstance().token(token).build();
        return this.identityService.verifyJwtToken(tokenRepresentation, this.dspCallbackAddress);
    }

    private <M extends TransferRemoteMessage> Result<M> validateProcessId(MessageSpec<?> messageSpec, M message) {
        String actual;
        String expected = messageSpec.getProcessId();
        if (expected != null && !expected.equals(actual = message.getProcessId())) {
            return Result.failure((String)String.format("Invalid process ID. Expected: %s, actual: %s", expected, actual));
        }
        return Result.success(message);
    }

    private Response createTransferProcessResponse(TransferProcess transferProcess) {
        return (Response)this.registry.transform((Object)transferProcess, JsonObject.class).map(transformedJson -> Response.ok().type("application/json").entity(transformedJson).build()).orElse(failure -> {
            UUID errorCode = UUID.randomUUID();
            this.monitor.warning(String.format("Error transforming transfer process, error id %s: %s", errorCode, failure.getFailureDetail()), new Throwable[0]);
            return DspTransferProcessApiController.error().processId(transferProcess.getCorrelationId()).message(String.format("Error code %s", errorCode)).internalServerError();
        });
    }

    @NotNull
    private static DspErrorResponse error() {
        return DspErrorResponse.type((String)"https://w3id.org/dspace/v0.8/TransferError");
    }
}

