/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.to;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.transform.spi.MissingPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToContractRequestMessageTransformer
extends AbstractJsonLdTransformer<JsonObject, ContractRequestMessage> {
    public JsonObjectToContractRequestMessageTransformer() {
        super(JsonObject.class, ContractRequestMessage.class);
    }

    @Nullable
    public ContractRequestMessage transform(@NotNull JsonObject requestObject, @NotNull TransformerContext context) {
        String id;
        Policy policy;
        JsonObject contractOffer;
        JsonValue callback;
        JsonValue providerPid;
        ContractRequestMessage.Builder builder = ContractRequestMessage.Builder.newInstance();
        if (!this.transformMandatoryString((JsonValue)requestObject.get((Object)"https://w3id.org/dspace/v0.8/consumerPid"), arg_0 -> ((ContractRequestMessage.Builder)builder).consumerPid(arg_0), context)) {
            JsonValue processId = (JsonValue)requestObject.get((Object)"https://w3id.org/dspace/v0.8/processId");
            if (processId == null) {
                ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractRequestMessage")).property("https://w3id.org/dspace/v0.8/consumerPid")).report();
                return null;
            }
            builder.consumerPid(this.transformString(processId, context));
        }
        if ((providerPid = (JsonValue)requestObject.get((Object)"https://w3id.org/dspace/v0.8/providerPid")) != null) {
            builder.providerPid(this.transformString(providerPid, context));
        }
        if ((callback = (JsonValue)requestObject.get((Object)"https://w3id.org/dspace/v0.8/callbackAddress")) != null) {
            builder.callbackAddress(this.transformString(callback, context));
        }
        if ((contractOffer = this.returnJsonObject((JsonValue)requestObject.get((Object)"https://w3id.org/dspace/v0.8/offer"), context, "https://w3id.org/dspace/v0.8/offer", false)) != null) {
            policy = (Policy)this.transformObject((JsonValue)contractOffer, Policy.class, context);
            if (policy == null) {
                ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractRequestMessage")).property("https://w3id.org/dspace/v0.8/offer")).report();
                return null;
            }
            id = this.nodeId((JsonValue)contractOffer);
            if (id == null) {
                ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/offer")).property("@id")).report();
                return null;
            }
        } else {
            if (context.hasProblems()) {
                return null;
            }
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractRequestMessage")).property("https://w3id.org/dspace/v0.8/offer")).report();
            return null;
        }
        ContractOffer offer = ContractOffer.Builder.newInstance().id(id).assetId(policy.getTarget()).policy(policy).build();
        builder.contractOffer(offer);
        return builder.build();
    }
}

