/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.NullPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractOfferMessageTransformer
extends AbstractJsonLdTransformer<ContractOfferMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractOfferMessageTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractOfferMessage.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractOfferMessage message, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", message.getId()).add("@type", "https://w3id.org/dspace/v0.8/ContractOfferMessage").add("https://w3id.org/dspace/v0.8/providerPid", message.getProviderPid()).add("https://w3id.org/dspace/v0.8/processId", message.getProcessId());
        this.addIfNotNull(message.getConsumerPid(), "https://w3id.org/dspace/v0.8/consumerPid", builder);
        this.addIfNotNull(message.getCallbackAddress(), "https://w3id.org/dspace/v0.8/callbackAddress", builder);
        ContractOffer offer = message.getContractOffer();
        JsonObject policy = (JsonObject)context.transform((Object)offer.getPolicy(), JsonObject.class);
        if (policy == null) {
            ((NullPropertyBuilder)((NullPropertyBuilder)context.problem().nullProperty().type(ContractOfferMessage.class)).property("contractOffer")).report();
            return null;
        }
        JsonObject enrichedPolicy = Json.createObjectBuilder((JsonObject)policy).add("@id", offer.getId()).build();
        builder.add("https://w3id.org/dspace/v0.8/offer", (JsonValue)enrichedPolicy);
        return builder.build();
    }
}

