/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationTerminationMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractNegotiationTerminationMessageTransformer
extends AbstractJsonLdTransformer<ContractNegotiationTerminationMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractNegotiationTerminationMessageTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractNegotiationTerminationMessage.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractNegotiationTerminationMessage terminationMessage, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", terminationMessage.getId()).add("@type", "https://w3id.org/dspace/v0.8/ContractNegotiationTerminationMessage").add("https://w3id.org/dspace/v0.8/consumerPid", terminationMessage.getConsumerPid()).add("https://w3id.org/dspace/v0.8/providerPid", terminationMessage.getProviderPid()).add("https://w3id.org/dspace/v0.8/processId", terminationMessage.getProcessId());
        this.addIfNotNull(terminationMessage.getRejectionReason(), "https://w3id.org/dspace/v0.8/reason", builder);
        this.addIfNotNull(terminationMessage.getCode(), "https://w3id.org/dspace/v0.8/code", builder);
        return builder.build();
    }
}

