/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.NullPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractRequestMessageTransformer
extends AbstractJsonLdTransformer<ContractRequestMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractRequestMessageTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractRequestMessage.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractRequestMessage requestMessage, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", requestMessage.getId()).add("@type", "https://w3id.org/dspace/v0.8/ContractRequestMessage").add("https://w3id.org/dspace/v0.8/consumerPid", requestMessage.getConsumerPid()).add("https://w3id.org/dspace/v0.8/processId", requestMessage.getProcessId());
        this.addIfNotNull(requestMessage.getProviderPid(), "https://w3id.org/dspace/v0.8/providerPid", builder);
        this.addIfNotNull(requestMessage.getCallbackAddress(), "https://w3id.org/dspace/v0.8/callbackAddress", builder);
        JsonObject policy = (JsonObject)context.transform((Object)requestMessage.getContractOffer().getPolicy(), JsonObject.class);
        if (policy == null) {
            ((NullPropertyBuilder)((NullPropertyBuilder)context.problem().nullProperty().type(ContractRequestMessage.class)).property("contractOffer")).report();
            return null;
        }
        JsonObject enrichedPolicy = Json.createObjectBuilder((JsonObject)policy).add("@id", requestMessage.getContractOffer().getId()).build();
        builder.add("https://w3id.org/dspace/v0.8/offer", (JsonValue)enrichedPolicy);
        return builder.build();
    }
}

