/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractNegotiationEventMessageTransformer
extends AbstractJsonLdTransformer<ContractNegotiationEventMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractNegotiationEventMessageTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractNegotiationEventMessage.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractNegotiationEventMessage eventMessage, @NotNull TransformerContext context) {
        JsonObjectBuilder jsonObjectBuilder = this.jsonFactory.createObjectBuilder().add("@id", eventMessage.getId()).add("@type", "https://w3id.org/dspace/v0.8/ContractNegotiationEventMessage").add("https://w3id.org/dspace/v0.8/consumerPid", eventMessage.getConsumerPid()).add("https://w3id.org/dspace/v0.8/providerPid", eventMessage.getProviderPid()).add("https://w3id.org/dspace/v0.8/processId", eventMessage.getProcessId());
        return jsonObjectBuilder.add("https://w3id.org/dspace/v0.8/eventType", switch (eventMessage.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ContractNegotiationEventMessage.Type.ACCEPTED -> "https://w3id.org/dspace/v0.8/ACCEPTED";
            case ContractNegotiationEventMessage.Type.FINALIZED -> "https://w3id.org/dspace/v0.8/FINALIZED";
        }).build();
    }
}

