/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.to;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Set;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.types.domain.agreement.ContractAgreement;
import org.eclipse.edc.transform.spi.InvalidPropertyBuilder;
import org.eclipse.edc.transform.spi.MissingPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToContractAgreementMessageTransformer
extends AbstractJsonLdTransformer<JsonObject, ContractAgreementMessage> {
    private static final Set<String> EXCLUDED_POLICY_KEYWORDS = Set.of("https://w3id.org/dspace/v0.8/consumerId", "https://w3id.org/dspace/v0.8/providerId", "https://w3id.org/dspace/v0.8/timestamp");

    public JsonObjectToContractAgreementMessageTransformer() {
        super(JsonObject.class, ContractAgreementMessage.class);
    }

    @Nullable
    public ContractAgreementMessage transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        JsonObject jsonAgreement;
        ContractAgreementMessage.Builder messageBuilder = ContractAgreementMessage.Builder.newInstance();
        JsonValue processId = (JsonValue)object.get((Object)"https://w3id.org/dspace/v0.8/processId");
        if (!this.transformMandatoryString((JsonValue)object.get((Object)"https://w3id.org/dspace/v0.8/consumerPid"), arg_0 -> ((ContractAgreementMessage.Builder)messageBuilder).consumerPid(arg_0), context)) {
            if (processId == null) {
                ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractAgreementMessage")).property("https://w3id.org/dspace/v0.8/consumerPid")).report();
                return null;
            }
            messageBuilder.consumerPid(this.transformString(processId, context));
        }
        if (!this.transformMandatoryString((JsonValue)object.get((Object)"https://w3id.org/dspace/v0.8/providerPid"), arg_0 -> ((ContractAgreementMessage.Builder)messageBuilder).providerPid(arg_0), context)) {
            if (processId == null) {
                ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractAgreementMessage")).property("https://w3id.org/dspace/v0.8/providerPid")).report();
                return null;
            }
            messageBuilder.providerPid(this.transformString(processId, context));
        }
        if ((jsonAgreement = this.returnMandatoryJsonObject((JsonValue)object.get((Object)"https://w3id.org/dspace/v0.8/agreement"), context, "https://w3id.org/dspace/v0.8/agreement")) == null) {
            return null;
        }
        JsonObject filteredJsonAgreement = this.filterAgreementProperties(jsonAgreement);
        Policy policy = (Policy)context.transform((Object)filteredJsonAgreement, Policy.class);
        if (policy == null) {
            ((InvalidPropertyBuilder)((InvalidPropertyBuilder)context.problem().invalidProperty().type("https://w3id.org/dspace/v0.8/ContractAgreementMessage")).property("https://w3id.org/dspace/v0.8/agreement")).report();
            return null;
        }
        ContractAgreement agreement = this.contractAgreement(jsonAgreement, policy, context);
        if (agreement == null) {
            return null;
        }
        messageBuilder.contractAgreement(agreement);
        return messageBuilder.build();
    }

    private JsonObject filterAgreementProperties(JsonObject jsonAgreement) {
        JsonObjectBuilder copiedJsonAgreement = Json.createObjectBuilder();
        jsonAgreement.entrySet().stream().filter(e -> !EXCLUDED_POLICY_KEYWORDS.contains(e.getKey())).forEach(e -> copiedJsonAgreement.add((String)e.getKey(), (JsonValue)e.getValue()));
        return copiedJsonAgreement.build();
    }

    @Nullable
    private ContractAgreement contractAgreement(JsonObject jsonAgreement, Policy policy, TransformerContext context) {
        String timestamp;
        ContractAgreement.Builder builder = ContractAgreement.Builder.newInstance();
        String agreementId = this.nodeId((JsonValue)jsonAgreement);
        if (agreementId == null) {
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractAgreementMessage")).property("@id")).report();
            return null;
        }
        String assignee = policy.getAssignee();
        String assigner = policy.getAssigner();
        builder.id(agreementId).consumerId(assignee).providerId(assigner).policy(policy).assetId(policy.getTarget());
        if (assignee == null) {
            if (!this.transformMandatoryString((JsonValue)jsonAgreement.get((Object)"https://w3id.org/dspace/v0.8/consumerId"), arg_0 -> ((ContractAgreement.Builder)builder).consumerId(arg_0), context)) {
                ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractAgreementMessage")).property("https://w3id.org/dspace/v0.8/consumerId")).report();
                return null;
            }
        }
        if (assigner == null) {
            if (!this.transformMandatoryString((JsonValue)jsonAgreement.get((Object)"https://w3id.org/dspace/v0.8/providerId"), arg_0 -> ((ContractAgreement.Builder)builder).providerId(arg_0), context)) {
                ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractAgreementMessage")).property("https://w3id.org/dspace/v0.8/providerId")).report();
                return null;
            }
        }
        if ((timestamp = this.transformString((JsonValue)jsonAgreement.get((Object)"https://w3id.org/dspace/v0.8/timestamp"), context)) == null) {
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractAgreementMessage")).property("https://w3id.org/dspace/v0.8/timestamp")).report();
            return null;
        }
        try {
            builder.contractSigningDate(Instant.parse(timestamp).getEpochSecond());
        }
        catch (DateTimeParseException e) {
            ((InvalidPropertyBuilder)((InvalidPropertyBuilder)context.problem().invalidProperty().type("https://w3id.org/dspace/v0.8/ContractAgreementMessage")).property("https://w3id.org/dspace/v0.8/timestamp")).value(timestamp).error(e.getMessage()).report();
            return null;
        }
        return builder.build();
    }
}

