/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiationStates;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.NullPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.edc.transform.spi.UnexpectedTypeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractNegotiationTransformer
extends AbstractJsonLdTransformer<ContractNegotiation, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractNegotiationTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractNegotiation.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractNegotiation contractNegotiation, @NotNull TransformerContext context) {
        return this.jsonFactory.createObjectBuilder().add("@id", this.pidFor(contractNegotiation, contractNegotiation.getType())).add("@type", "https://w3id.org/dspace/v0.8/ContractNegotiation").add("https://w3id.org/dspace/v0.8/consumerPid", this.pidFor(contractNegotiation, ContractNegotiation.Type.CONSUMER)).add("https://w3id.org/dspace/v0.8/providerPid", this.pidFor(contractNegotiation, ContractNegotiation.Type.PROVIDER)).add("https://w3id.org/dspace/v0.8/processId", this.pidFor(contractNegotiation, ContractNegotiation.Type.CONSUMER)).add("https://w3id.org/dspace/v0.8/state", this.state(contractNegotiation.getState(), context)).build();
    }

    private String pidFor(@NotNull ContractNegotiation contractNegotiation, ContractNegotiation.Type type) {
        return contractNegotiation.getType() == type ? contractNegotiation.getId() : contractNegotiation.getCorrelationId();
    }

    private String state(Integer state, TransformerContext context) {
        ContractNegotiationStates negotiationState = ContractNegotiationStates.from((int)state);
        if (negotiationState == null) {
            ((NullPropertyBuilder)((NullPropertyBuilder)context.problem().nullProperty().type(ContractNegotiation.class)).property("https://w3id.org/dspace/v0.8/state")).report();
            return null;
        }
        return switch (negotiationState) {
            case ContractNegotiationStates.REQUESTING, ContractNegotiationStates.REQUESTED -> "https://w3id.org/dspace/v0.8/REQUESTED";
            case ContractNegotiationStates.OFFERING, ContractNegotiationStates.OFFERED -> "https://w3id.org/dspace/v0.8/OFFERED";
            case ContractNegotiationStates.ACCEPTING, ContractNegotiationStates.ACCEPTED -> "https://w3id.org/dspace/v0.8/ACCEPTED";
            case ContractNegotiationStates.AGREEING, ContractNegotiationStates.AGREED -> "https://w3id.org/dspace/v0.8/AGREED";
            case ContractNegotiationStates.VERIFYING, ContractNegotiationStates.VERIFIED -> "https://w3id.org/dspace/v0.8/VERIFIED";
            case ContractNegotiationStates.FINALIZING, ContractNegotiationStates.FINALIZED -> "https://w3id.org/dspace/v0.8/FINALIZED";
            case ContractNegotiationStates.TERMINATING, ContractNegotiationStates.TERMINATED -> "https://w3id.org/dspace/v0.8/TERMINATED";
            default -> {
                ((UnexpectedTypeBuilder)((UnexpectedTypeBuilder)context.problem().unexpectedType().type(ContractNegotiation.class)).property("state")).actual(negotiationState.toString()).expected(ContractNegotiationStates.class).report();
                yield null;
            }
        };
    }
}

