/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.time.Instant;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.agreement.ContractAgreement;
import org.eclipse.edc.transform.spi.NullPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractAgreementMessageTransformer
extends AbstractJsonLdTransformer<ContractAgreementMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractAgreementMessageTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractAgreementMessage.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractAgreementMessage agreementMessage, @NotNull TransformerContext context) {
        ContractAgreement agreement = agreementMessage.getContractAgreement();
        JsonObject policy = (JsonObject)context.transform((Object)agreement.getPolicy(), JsonObject.class);
        if (policy == null) {
            ((NullPropertyBuilder)((NullPropertyBuilder)context.problem().nullProperty().type(ContractAgreementMessage.class)).property("policy")).report();
            return null;
        }
        String signing = Instant.ofEpochSecond(agreement.getContractSigningDate()).toString();
        JsonObject copiedPolicy = Json.createObjectBuilder((JsonObject)policy).add("@id", agreement.getId()).add("http://www.w3.org/ns/odrl/2/assignee", agreement.getConsumerId()).add("http://www.w3.org/ns/odrl/2/assigner", agreement.getProviderId()).add("https://w3id.org/dspace/v0.8/consumerId", agreement.getConsumerId()).add("https://w3id.org/dspace/v0.8/providerId", agreement.getProviderId()).add("https://w3id.org/dspace/v0.8/timestamp", signing).build();
        return this.jsonFactory.createObjectBuilder().add("@id", agreementMessage.getId()).add("@type", "https://w3id.org/dspace/v0.8/ContractAgreementMessage").add("https://w3id.org/dspace/v0.8/providerPid", agreementMessage.getProviderPid()).add("https://w3id.org/dspace/v0.8/consumerPid", agreementMessage.getConsumerPid()).add("https://w3id.org/dspace/v0.8/processId", agreementMessage.getProcessId()).add("https://w3id.org/dspace/v0.8/agreement", (JsonValue)copiedPolicy).build();
    }
}

