/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.NullPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractOfferMessageTransformer
extends AbstractJsonLdTransformer<ContractOfferMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractOfferMessageTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractOfferMessage.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractOfferMessage message, @NotNull TransformerContext context) {
        ContractOffer offer;
        JsonObject policy;
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder();
        builder.add("@id", message.getId());
        builder.add("@type", "https://w3id.org/dspace/v0.8/ContractOfferMessage");
        builder.add("https://w3id.org/dspace/v0.8/processId", message.getProcessId());
        if (message.getCallbackAddress() != null) {
            builder.add("https://w3id.org/dspace/v0.8/callbackAddress", message.getCallbackAddress());
        }
        if ((policy = (JsonObject)context.transform((Object)(offer = message.getContractOffer()).getPolicy(), JsonObject.class)) == null) {
            ((NullPropertyBuilder)((NullPropertyBuilder)context.problem().nullProperty().type(ContractOfferMessage.class)).property("contractOffer")).report();
            return null;
        }
        JsonObject enrichedPolicy = Json.createObjectBuilder((JsonObject)policy).add("@id", offer.getId()).build();
        builder.add("https://w3id.org/dspace/v0.8/offer", (JsonValue)enrichedPolicy);
        return builder.build();
    }
}

