/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiationStates;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.NullPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.edc.transform.spi.UnexpectedTypeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractNegotiationTransformer
extends AbstractJsonLdTransformer<ContractNegotiation, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractNegotiationTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractNegotiation.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractNegotiation contractNegotiation, @NotNull TransformerContext context) {
        return this.jsonFactory.createObjectBuilder().add("@id", contractNegotiation.getCorrelationId()).add("@type", "https://w3id.org/dspace/v0.8/ContractNegotiation").add("https://w3id.org/dspace/v0.8/processId", contractNegotiation.getCorrelationId()).add("https://w3id.org/dspace/v0.8/state", this.state(contractNegotiation.getState(), context)).build();
    }

    private String state(Integer state, TransformerContext context) {
        ContractNegotiationStates negotiationState = ContractNegotiationStates.from((int)state);
        if (negotiationState == null) {
            ((NullPropertyBuilder)((NullPropertyBuilder)context.problem().nullProperty().type(ContractNegotiation.class)).property("https://w3id.org/dspace/v0.8/state")).report();
            return null;
        }
        switch (negotiationState) {
            case REQUESTING: 
            case REQUESTED: {
                return "https://w3id.org/dspace/v0.8/REQUESTED";
            }
            case OFFERING: 
            case OFFERED: {
                return "https://w3id.org/dspace/v0.8/OFFERED";
            }
            case ACCEPTING: 
            case ACCEPTED: {
                return "https://w3id.org/dspace/v0.8/ACCEPTED";
            }
            case AGREEING: 
            case AGREED: {
                return "https://w3id.org/dspace/v0.8/AGREED";
            }
            case VERIFYING: 
            case VERIFIED: {
                return "https://w3id.org/dspace/v0.8/VERIFIED";
            }
            case FINALIZING: 
            case FINALIZED: {
                return "https://w3id.org/dspace/v0.8/FINALIZED";
            }
            case TERMINATING: 
            case TERMINATED: {
                return "https://w3id.org/dspace/v0.8/TERMINATED";
            }
        }
        ((UnexpectedTypeBuilder)((UnexpectedTypeBuilder)context.problem().unexpectedType().type(ContractNegotiation.class)).property("state")).actual(negotiationState.toString()).expected(ContractNegotiationStates.class).report();
        return null;
    }
}

