/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractNegotiationEventMessageTransformer
extends AbstractJsonLdTransformer<ContractNegotiationEventMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractNegotiationEventMessageTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractNegotiationEventMessage.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractNegotiationEventMessage eventMessage, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder();
        builder.add("@id", eventMessage.getId());
        builder.add("@type", "https://w3id.org/dspace/v0.8/ContractNegotiationEventMessage");
        builder.add("https://w3id.org/dspace/v0.8/processId", eventMessage.getProcessId());
        builder.add("https://w3id.org/dspace/v0.8/eventType", this.eventType(eventMessage));
        return builder.build();
    }

    @NotNull
    private String eventType(ContractNegotiationEventMessage message) {
        switch (message.getType()) {
            case ACCEPTED: {
                return "https://w3id.org/dspace/v0.8/ACCEPTED";
            }
            case FINALIZED: {
                return "https://w3id.org/dspace/v0.8/FINALIZED";
            }
        }
        throw new EdcException("Unknown event type: " + message.getType());
    }
}

