/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.to;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Optional;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.connector.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.transform.spi.MissingPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToContractRequestMessageTransformer
extends AbstractJsonLdTransformer<JsonObject, ContractRequestMessage> {
    public JsonObjectToContractRequestMessageTransformer() {
        super(JsonObject.class, ContractRequestMessage.class);
    }

    @Nullable
    public ContractRequestMessage transform(@NotNull JsonObject requestObject, @NotNull TransformerContext context) {
        JsonObject contractOffer;
        JsonValue dataset;
        ContractRequestMessage.Builder builder = ContractRequestMessage.Builder.newInstance();
        if (!this.transformMandatoryString((JsonValue)requestObject.get((Object)"https://w3id.org/dspace/v0.8/processId"), arg_0 -> ((ContractRequestMessage.Builder)builder).processId(arg_0), context)) {
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractRequestMessage")).property("https://w3id.org/dspace/v0.8/processId")).report();
            return null;
        }
        JsonValue callback = (JsonValue)requestObject.get((Object)"https://w3id.org/dspace/v0.8/callbackAddress");
        if (callback != null) {
            builder.callbackAddress(this.transformString(callback, context));
        }
        if ((dataset = Optional.of(requestObject).map(it -> (JsonValue)it.get((Object)"https://w3id.org/dspace/v0.8/dataset")).orElseGet(() -> (JsonValue)requestObject.get((Object)"https://w3id.org/dspace/v0.8/dataSet"))) != null) {
            builder.dataset(this.transformString(dataset, context));
        }
        if ((contractOffer = this.returnJsonObject((JsonValue)requestObject.get((Object)"https://w3id.org/dspace/v0.8/offer"), context, "https://w3id.org/dspace/v0.8/offer", false)) != null) {
            Policy policy = (Policy)this.transformObject((JsonValue)contractOffer, Policy.class, context);
            if (policy == null) {
                ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractRequestMessage")).property("https://w3id.org/dspace/v0.8/offer")).report();
                return null;
            }
            String id = this.nodeId((JsonValue)contractOffer);
            if (id == null) {
                ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/offer")).property("@id")).report();
                return null;
            }
            ContractOffer offer = ContractOffer.Builder.newInstance().id(id).assetId(policy.getTarget()).policy(policy).build();
            builder.contractOffer(offer);
        } else {
            if (context.hasProblems()) {
                return null;
            }
            if (!this.transformMandatoryString((JsonValue)requestObject.get((Object)"https://w3id.org/dspace/v0.8/offerId"), arg_0 -> ((ContractRequestMessage.Builder)builder).contractOfferId(arg_0), context)) {
                ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/ContractRequestMessage")).property("https://w3id.org/dspace/v0.8/offer")).report();
                return null;
            }
        }
        return builder.build();
    }
}

