/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiationTerminationMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractNegotiationTerminationMessageTransformer
extends AbstractJsonLdTransformer<ContractNegotiationTerminationMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractNegotiationTerminationMessageTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractNegotiationTerminationMessage.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractNegotiationTerminationMessage terminationMessage, @NotNull TransformerContext context) {
        String code;
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder();
        builder.add("@id", terminationMessage.getId());
        builder.add("@type", "https://w3id.org/dspace/v0.8/ContractNegotiationTerminationMessage");
        builder.add("https://w3id.org/dspace/v0.8/processId", terminationMessage.getProcessId());
        String rejectionReason = terminationMessage.getRejectionReason();
        if (rejectionReason != null) {
            builder.add("https://w3id.org/dspace/v0.8/reason", rejectionReason);
        }
        if ((code = terminationMessage.getCode()) != null) {
            builder.add("https://w3id.org/dspace/v0.8/code", code);
        }
        return builder.build();
    }
}

