/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractAgreementMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractAgreementVerificationMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractNegotiationErrorTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractNegotiationEventMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractNegotiationTerminationMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractNegotiationTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractOfferMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractRequestMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractAgreementMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractAgreementVerificationMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractNegotiationAckTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractNegotiationEventMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractNegotiationTerminationMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractOfferMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractRequestMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from.JsonObjectFromContractAgreementMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from.JsonObjectFromContractAgreementVerificationMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from.JsonObjectFromContractNegotiationEventMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from.JsonObjectFromContractNegotiationTerminationMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from.JsonObjectFromContractNegotiationV2024Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from.JsonObjectFromContractOfferMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from.JsonObjectFromContractRequestMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.spi.type.DspConstants;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;

@Extension(value="Dataspace Protocol Negotiation Transform Extension")
public class DspNegotiationTransformExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Negotiation Transform Extension";
    @Inject
    private TypeTransformerRegistry registry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.registerV08transformers();
        this.registerV2024transformers();
        this.registerTransformers("dsp-api:v0.8", DspConstants.DSP_NAMESPACE_V_08);
        this.registerTransformers("dsp-api:2024/1", DspConstants.DSP_NAMESPACE_V_2024_1);
    }

    private void registerTransformers(String version, JsonLdNamespace namespace) {
        JsonBuilderFactory builderFactory = Json.createBuilderFactory(Map.of());
        TypeTransformerRegistry dspApiTransformerRegistry = this.registry.forContext(version);
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationErrorTransformer(builderFactory, namespace));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractAgreementMessageTransformer(namespace));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractAgreementVerificationMessageTransformer(namespace));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractNegotiationEventMessageTransformer(namespace));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractRequestMessageTransformer(namespace));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractNegotiationTerminationMessageTransformer(namespace));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractOfferMessageTransformer(namespace));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractNegotiationAckTransformer(namespace));
    }

    private void registerV08transformers() {
        JsonBuilderFactory builderFactory = Json.createBuilderFactory(Map.of());
        TypeTransformerRegistry dspApiTransformerRegistry = this.registry.forContext("dsp-api:v0.8");
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractRequestMessageTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractOfferMessageTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractAgreementMessageTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractAgreementVerificationMessageTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationEventMessageTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationTerminationMessageTransformer(builderFactory));
    }

    private void registerV2024transformers() {
        JsonBuilderFactory builderFactory = Json.createBuilderFactory(Map.of());
        TypeTransformerRegistry dspApiTransformerRegistry = this.registry.forContext("dsp-api:2024/1");
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationV2024Transformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractRequestMessageV2024Transformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractOfferMessageV2024Transformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractAgreementMessageV2024Transformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractAgreementVerificationMessageV2024Transformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationEventMessageV2024Transformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationTerminationMessageV2024Transformer(builderFactory));
    }
}

