/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.jsonld.spi.transformer.AbstractNamespaceAwareJsonLdTransformer;
import org.eclipse.edc.transform.spi.NullPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractOfferMessageV2024Transformer
extends AbstractNamespaceAwareJsonLdTransformer<ContractOfferMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractOfferMessageV2024Transformer(JsonBuilderFactory jsonFactory, JsonLdNamespace namespace) {
        super(ContractOfferMessage.class, JsonObject.class, namespace);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractOfferMessage message, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", message.getId()).add("@type", this.forNamespace("ContractOfferMessage")).add(this.forNamespace("providerPid"), (JsonValue)this.createId(this.jsonFactory, message.getProviderPid()));
        this.addIdIfNotNull(message.getConsumerPid(), this.forNamespace("consumerPid"), this.jsonFactory, builder);
        this.addIfNotNull(message.getCallbackAddress(), this.forNamespace("callbackAddress"), builder);
        ContractOffer offer = message.getContractOffer();
        JsonObject policy = (JsonObject)context.transform((Object)offer.getPolicy(), JsonObject.class);
        if (policy == null) {
            ((NullPropertyBuilder)((NullPropertyBuilder)context.problem().nullProperty().type(ContractOfferMessage.class)).property("contractOffer")).report();
            return null;
        }
        JsonObject enrichedPolicy = Json.createObjectBuilder((JsonObject)policy).add("@id", offer.getId()).build();
        builder.add(this.forNamespace("offer"), (JsonValue)enrichedPolicy);
        return builder.build();
    }
}

