/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.jsonld.spi.transformer.AbstractNamespaceAwareJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractNegotiationEventMessageV2024Transformer
extends AbstractNamespaceAwareJsonLdTransformer<ContractNegotiationEventMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractNegotiationEventMessageV2024Transformer(JsonBuilderFactory jsonFactory, JsonLdNamespace namespace) {
        super(ContractNegotiationEventMessage.class, JsonObject.class, namespace);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractNegotiationEventMessage eventMessage, @NotNull TransformerContext context) {
        JsonObjectBuilder jsonObjectBuilder = this.jsonFactory.createObjectBuilder().add("@id", eventMessage.getId()).add("@type", this.forNamespace("ContractNegotiationEventMessage")).add(this.forNamespace("consumerPid"), (JsonValue)this.createId(this.jsonFactory, eventMessage.getConsumerPid())).add(this.forNamespace("providerPid"), (JsonValue)this.createId(this.jsonFactory, eventMessage.getProviderPid()));
        String string = this.forNamespace("eventType");
        return jsonObjectBuilder.add(string, (JsonValue)(switch (eventMessage.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ContractNegotiationEventMessage.Type.ACCEPTED -> this.createId(this.jsonFactory, this.forNamespace("ACCEPTED"));
            case ContractNegotiationEventMessage.Type.FINALIZED -> this.createId(this.jsonFactory, this.forNamespace("FINALIZED"));
        })).build();
    }
}

