/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.time.Instant;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.jsonld.spi.transformer.AbstractNamespaceAwareJsonLdTransformer;
import org.eclipse.edc.transform.spi.NullPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractAgreementMessageV2024Transformer
extends AbstractNamespaceAwareJsonLdTransformer<ContractAgreementMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractAgreementMessageV2024Transformer(JsonBuilderFactory jsonFactory, JsonLdNamespace namespace) {
        super(ContractAgreementMessage.class, JsonObject.class, namespace);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractAgreementMessage agreementMessage, @NotNull TransformerContext context) {
        ContractAgreement agreement = agreementMessage.getContractAgreement();
        JsonObject policy = (JsonObject)context.transform((Object)agreement.getPolicy(), JsonObject.class);
        if (policy == null) {
            ((NullPropertyBuilder)((NullPropertyBuilder)context.problem().nullProperty().type(ContractAgreementMessage.class)).property("policy")).report();
            return null;
        }
        String signing = Instant.ofEpochSecond(agreement.getContractSigningDate()).toString();
        JsonObject copiedPolicy = Json.createObjectBuilder((JsonObject)policy).add("@id", agreement.getId()).add("http://www.w3.org/ns/odrl/2/assignee", (JsonValue)this.createId(this.jsonFactory, agreement.getConsumerId())).add("http://www.w3.org/ns/odrl/2/assigner", (JsonValue)this.createId(this.jsonFactory, agreement.getProviderId())).add(this.forNamespace("timestamp"), signing).build();
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", agreementMessage.getId()).add("@type", this.forNamespace("ContractAgreementMessage")).add(this.forNamespace("providerPid"), (JsonValue)this.createId(this.jsonFactory, agreementMessage.getProviderPid())).add(this.forNamespace("consumerPid"), (JsonValue)this.createId(this.jsonFactory, agreementMessage.getConsumerPid())).add(this.forNamespace("agreement"), (JsonValue)copiedPolicy);
        if (agreementMessage.getCallbackAddress() != null) {
            builder.add(this.forNamespace("callbackAddress"), agreementMessage.getCallbackAddress());
        }
        return builder.build();
    }
}

