/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.to;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.jsonld.spi.transformer.AbstractNamespaceAwareJsonLdTransformer;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.policy.model.PolicyType;
import org.eclipse.edc.transform.spi.MissingPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToContractOfferMessageTransformer
extends AbstractNamespaceAwareJsonLdTransformer<JsonObject, ContractOfferMessage> {
    public JsonObjectToContractOfferMessageTransformer(JsonLdNamespace namespace) {
        super(JsonObject.class, ContractOfferMessage.class, namespace);
    }

    @Nullable
    public ContractOfferMessage transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        String id;
        Policy policy;
        JsonObject contractOffer;
        JsonValue callback;
        ContractOfferMessage.Builder builder = ContractOfferMessage.Builder.newInstance();
        if (!this.transformMandatoryString((JsonValue)jsonObject.get((Object)this.forNamespace("providerPid")), arg_0 -> ((ContractOfferMessage.Builder)builder).providerPid(arg_0), context)) {
            this.reportMissingProperty(this.forNamespace("ContractOfferMessage"), this.forNamespace("providerPid"), context);
            return null;
        }
        JsonValue consumerPid = (JsonValue)jsonObject.get((Object)this.forNamespace("consumerPid"));
        if (consumerPid != null) {
            builder.consumerPid(this.transformString(consumerPid, context));
        }
        if ((callback = (JsonValue)jsonObject.get((Object)this.forNamespace("callbackAddress"))) != null) {
            builder.callbackAddress(this.transformString(callback, context));
        }
        if ((contractOffer = this.returnJsonObject((JsonValue)jsonObject.get((Object)this.forNamespace("offer")), context, this.forNamespace("offer"), false)) != null) {
            context.setData(Policy.class, "@type", (Object)PolicyType.OFFER);
            policy = (Policy)this.transformObject((JsonValue)contractOffer, Policy.class, context);
            if (policy == null) {
                this.reportMissingProperty(this.forNamespace("ContractOfferMessage"), this.forNamespace("offer"), context);
                return null;
            }
            id = this.nodeId((JsonValue)contractOffer);
            if (id == null) {
                this.reportMissingProperty(this.forNamespace("offer"), "@id", context);
                return null;
            }
        } else {
            this.reportMissingProperty(this.forNamespace("ContractOfferMessage"), this.forNamespace("offer"), context);
            return null;
        }
        ContractOffer offer = ContractOffer.Builder.newInstance().id(id).assetId(policy.getTarget()).policy(policy).build();
        builder.contractOffer(offer);
        return builder.build();
    }

    private void reportMissingProperty(String type, String property, TransformerContext context) {
        ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type(type)).property(property)).report();
    }
}

