/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.to;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Set;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.jsonld.spi.transformer.AbstractNamespaceAwareJsonLdTransformer;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.transform.spi.InvalidPropertyBuilder;
import org.eclipse.edc.transform.spi.MissingPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToContractAgreementMessageTransformer
extends AbstractNamespaceAwareJsonLdTransformer<JsonObject, ContractAgreementMessage> {
    private final Set<String> excludedPolicyKeywords = Set.of(this.forNamespace("timestamp"), this.forNamespace("consumerId"), this.forNamespace("providerId"));

    public JsonObjectToContractAgreementMessageTransformer(JsonLdNamespace namespace) {
        super(JsonObject.class, ContractAgreementMessage.class, namespace);
    }

    @Nullable
    public ContractAgreementMessage transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        ContractAgreementMessage.Builder messageBuilder = ContractAgreementMessage.Builder.newInstance();
        if (!this.transformMandatoryString((JsonValue)object.get((Object)this.forNamespace("consumerPid")), arg_0 -> ((ContractAgreementMessage.Builder)messageBuilder).consumerPid(arg_0), context)) {
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type(this.forNamespace("ContractAgreementMessage"))).property(this.forNamespace("consumerPid"))).report();
            return null;
        }
        if (!this.transformMandatoryString((JsonValue)object.get((Object)this.forNamespace("providerPid")), arg_0 -> ((ContractAgreementMessage.Builder)messageBuilder).providerPid(arg_0), context)) {
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type(this.forNamespace("ContractAgreementMessage"))).property(this.forNamespace("providerPid"))).report();
            return null;
        }
        JsonObject jsonAgreement = this.returnMandatoryJsonObject((JsonValue)object.get((Object)this.forNamespace("agreement")), context, this.forNamespace("agreement"));
        if (jsonAgreement == null) {
            return null;
        }
        JsonObject filteredJsonAgreement = this.filterAgreementProperties(jsonAgreement);
        Policy policy = (Policy)context.transform((Object)filteredJsonAgreement, Policy.class);
        if (policy == null) {
            ((InvalidPropertyBuilder)((InvalidPropertyBuilder)context.problem().invalidProperty().type(this.forNamespace("ContractAgreementMessage"))).property(this.forNamespace("agreement"))).report();
            return null;
        }
        ContractAgreement agreement = this.contractAgreement(jsonAgreement, policy, context);
        if (agreement == null) {
            return null;
        }
        String callbackAddress = this.transformString((JsonValue)jsonAgreement.get((Object)this.forNamespace("callbackAddress")), context);
        messageBuilder.callbackAddress(callbackAddress);
        messageBuilder.contractAgreement(agreement);
        return messageBuilder.build();
    }

    private JsonObject filterAgreementProperties(JsonObject jsonAgreement) {
        JsonObjectBuilder copiedJsonAgreement = Json.createObjectBuilder();
        jsonAgreement.entrySet().stream().filter(e -> !this.excludedPolicyKeywords.contains(e.getKey())).forEach(e -> copiedJsonAgreement.add((String)e.getKey(), (JsonValue)e.getValue()));
        return copiedJsonAgreement.build();
    }

    @Nullable
    private ContractAgreement contractAgreement(JsonObject jsonAgreement, Policy policy, TransformerContext context) {
        ContractAgreement.Builder builder = ContractAgreement.Builder.newInstance();
        String agreementId = this.nodeId((JsonValue)jsonAgreement);
        if (agreementId == null) {
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type(this.forNamespace("ContractAgreementMessage"))).property("@id")).report();
            return null;
        }
        String assignee = policy.getAssignee();
        String assigner = policy.getAssigner();
        builder.id(agreementId).consumerId(assignee).providerId(assigner).policy(policy).assetId(policy.getTarget());
        String timestamp = this.transformString((JsonValue)jsonAgreement.get((Object)this.forNamespace("timestamp")), context);
        if (timestamp == null) {
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type(this.forNamespace("ContractAgreementMessage"))).property(this.forNamespace("timestamp"))).report();
            return null;
        }
        try {
            builder.contractSigningDate(Instant.parse(timestamp).getEpochSecond());
        }
        catch (DateTimeParseException e) {
            ((InvalidPropertyBuilder)((InvalidPropertyBuilder)context.problem().invalidProperty().type(this.forNamespace("ContractAgreementMessage"))).property(this.forNamespace("timestamp"))).value(timestamp).error(e.getMessage()).report();
            return null;
        }
        return builder.build();
    }
}

