/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationStates;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.jsonld.spi.transformer.AbstractNamespaceAwareJsonLdTransformer;
import org.eclipse.edc.transform.spi.NullPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.edc.transform.spi.UnexpectedTypeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractNegotiationTransformer
extends AbstractNamespaceAwareJsonLdTransformer<ContractNegotiation, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractNegotiationTransformer(JsonBuilderFactory jsonFactory, JsonLdNamespace namespace) {
        super(ContractNegotiation.class, JsonObject.class, namespace);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractNegotiation contractNegotiation, @NotNull TransformerContext context) {
        return this.jsonFactory.createObjectBuilder().add("@id", this.pidFor(contractNegotiation, contractNegotiation.getType())).add("@type", this.forNamespace("ContractNegotiation")).add(this.forNamespace("consumerPid"), this.pidFor(contractNegotiation, ContractNegotiation.Type.CONSUMER)).add(this.forNamespace("providerPid"), this.pidFor(contractNegotiation, ContractNegotiation.Type.PROVIDER)).add(this.forNamespace("state"), this.state(contractNegotiation.getState(), context)).build();
    }

    private String pidFor(@NotNull ContractNegotiation contractNegotiation, ContractNegotiation.Type type) {
        return contractNegotiation.getType() == type ? contractNegotiation.getId() : contractNegotiation.getCorrelationId();
    }

    private String state(Integer state, TransformerContext context) {
        ContractNegotiationStates negotiationState = ContractNegotiationStates.from((int)state);
        if (negotiationState == null) {
            ((NullPropertyBuilder)((NullPropertyBuilder)context.problem().nullProperty().type(ContractNegotiation.class)).property(this.forNamespace("state"))).report();
            return null;
        }
        return switch (negotiationState) {
            case ContractNegotiationStates.REQUESTING, ContractNegotiationStates.REQUESTED -> this.forNamespace("REQUESTED");
            case ContractNegotiationStates.OFFERING, ContractNegotiationStates.OFFERED -> this.forNamespace("OFFERED");
            case ContractNegotiationStates.ACCEPTING, ContractNegotiationStates.ACCEPTED -> this.forNamespace("ACCEPTED");
            case ContractNegotiationStates.AGREEING, ContractNegotiationStates.AGREED -> this.forNamespace("AGREED");
            case ContractNegotiationStates.VERIFYING, ContractNegotiationStates.VERIFIED -> this.forNamespace("VERIFIED");
            case ContractNegotiationStates.FINALIZING, ContractNegotiationStates.FINALIZED -> this.forNamespace("FINALIZED");
            case ContractNegotiationStates.TERMINATING, ContractNegotiationStates.TERMINATED -> this.forNamespace("TERMINATED");
            default -> {
                ((UnexpectedTypeBuilder)((UnexpectedTypeBuilder)context.problem().unexpectedType().type(ContractNegotiation.class)).property("state")).actual(negotiationState.toString()).expected(ContractNegotiationStates.class).report();
                yield null;
            }
        };
    }
}

