/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.jsonld.spi.transformer.AbstractNamespaceAwareJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractNegotiationEventMessageTransformer
extends AbstractNamespaceAwareJsonLdTransformer<ContractNegotiationEventMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractNegotiationEventMessageTransformer(JsonBuilderFactory jsonFactory, JsonLdNamespace namespace) {
        super(ContractNegotiationEventMessage.class, JsonObject.class, namespace);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractNegotiationEventMessage eventMessage, @NotNull TransformerContext context) {
        JsonObjectBuilder jsonObjectBuilder = this.jsonFactory.createObjectBuilder().add("@id", eventMessage.getId()).add("@type", this.forNamespace("ContractNegotiationEventMessage")).add(this.forNamespace("consumerPid"), eventMessage.getConsumerPid()).add(this.forNamespace("providerPid"), eventMessage.getProviderPid());
        String string = this.forNamespace("eventType");
        return jsonObjectBuilder.add(string, switch (eventMessage.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ContractNegotiationEventMessage.Type.ACCEPTED -> this.forNamespace("ACCEPTED");
            case ContractNegotiationEventMessage.Type.FINALIZED -> this.forNamespace("FINALIZED");
        }).build();
    }
}

