/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.v2025.from;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.jsonld.spi.transformer.AbstractNamespaceAwareJsonLdTransformer;
import org.eclipse.edc.transform.spi.NullPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractOfferMessageV2025Transformer
extends AbstractNamespaceAwareJsonLdTransformer<ContractOfferMessage, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractOfferMessageV2025Transformer(JsonBuilderFactory jsonFactory, JsonLdNamespace namespace) {
        super(ContractOfferMessage.class, JsonObject.class, namespace);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractOfferMessage message, @NotNull TransformerContext context) {
        ContractOffer offer;
        JsonObject policy;
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", message.getId()).add("@type", this.forNamespace("ContractOfferMessage")).add(this.forNamespace("providerPid"), (JsonValue)this.createId(this.jsonFactory, message.getProviderPid()));
        this.addIdIfNotNull(message.getConsumerPid(), this.forNamespace("consumerPid"), this.jsonFactory, builder);
        if (message.getConsumerPid() == null) {
            this.addIfNotNull(message.getCallbackAddress(), this.forNamespace("callbackAddress"), builder);
        }
        if ((policy = (JsonObject)context.transform((Object)(offer = message.getContractOffer()).getPolicy(), JsonObject.class)) == null) {
            ((NullPropertyBuilder)((NullPropertyBuilder)context.problem().nullProperty().type(ContractOfferMessage.class)).property("contractOffer")).report();
            return null;
        }
        JsonObject enrichedPolicy = Json.createObjectBuilder((JsonObject)policy).add("@id", offer.getId()).build();
        builder.add(this.forNamespace("offer"), (JsonValue)enrichedPolicy);
        return builder.build();
    }
}

