/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform.v2025;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractNegotiationErrorTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractAgreementMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractAgreementVerificationMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractNegotiationAckTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractNegotiationEventMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractNegotiationTerminationMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractOfferMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractRequestMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from.JsonObjectFromContractAgreementVerificationMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from.JsonObjectFromContractNegotiationEventMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from.JsonObjectFromContractNegotiationTerminationMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2024.from.JsonObjectFromContractNegotiationV2024Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2025.from.JsonObjectFromContractAgreementMessageV2025Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2025.from.JsonObjectFromContractOfferMessageV2025Transformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.v2025.from.JsonObjectFromContractRequestMessageV2025Transformer;
import org.eclipse.edc.protocol.dsp.spi.type.Dsp2025Constants;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;

@Extension(value="Dataspace Protocol 2025/1 Negotiation Transform Extension")
public class DspNegotiationTransformV2025Extension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol 2025/1 Negotiation Transform Extension";
    @Inject
    private TypeTransformerRegistry registry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.registerTransformers();
    }

    private void registerTransformers() {
        JsonBuilderFactory builderFactory = Json.createBuilderFactory(Map.of());
        TypeTransformerRegistry dspApiTransformerRegistry = this.registry.forContext("dsp-api:2025-1");
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationErrorTransformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractAgreementMessageTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractAgreementVerificationMessageTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractNegotiationEventMessageTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractRequestMessageTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractNegotiationTerminationMessageTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractOfferMessageTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractNegotiationAckTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationV2024Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractRequestMessageV2025Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractOfferMessageV2025Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractAgreementMessageV2025Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractAgreementVerificationMessageV2024Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationEventMessageV2024Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationTerminationMessageV2024Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
    }
}

