/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.transform;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractAgreementMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractAgreementVerificationMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractNegotiationErrorTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractNegotiationEventMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractNegotiationTerminationMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractNegotiationTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractOfferMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractRequestMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractAgreementMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractAgreementVerificationMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractNegotiationAckTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractNegotiationEventMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractNegotiationTerminationMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractOfferMessageTransformer;
import org.eclipse.edc.protocol.dsp.negotiation.transform.to.JsonObjectToContractRequestMessageTransformer;
import org.eclipse.edc.protocol.dsp.spi.type.DspConstants;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;

@Extension(value="Dataspace Protocol Negotiation Transform v08 Extension")
public class DspNegotiationTransformV08Extension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Negotiation Transform v08 Extension";
    @Inject
    private TypeTransformerRegistry registry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.registerTransformers();
    }

    private void registerTransformers() {
        JsonBuilderFactory builderFactory = Json.createBuilderFactory(Map.of());
        TypeTransformerRegistry dspApiTransformerRegistry = this.registry.forContext("dsp-api:v0.8");
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationErrorTransformer(builderFactory, DspConstants.DSP_NAMESPACE_V_08));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractAgreementMessageTransformer(DspConstants.DSP_NAMESPACE_V_08));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractAgreementVerificationMessageTransformer(DspConstants.DSP_NAMESPACE_V_08));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractNegotiationEventMessageTransformer(DspConstants.DSP_NAMESPACE_V_08));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractRequestMessageTransformer(DspConstants.DSP_NAMESPACE_V_08));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractNegotiationTerminationMessageTransformer(DspConstants.DSP_NAMESPACE_V_08));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractOfferMessageTransformer(DspConstants.DSP_NAMESPACE_V_08));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToContractNegotiationAckTransformer(DspConstants.DSP_NAMESPACE_V_08));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractRequestMessageTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractOfferMessageTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractAgreementMessageTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractAgreementVerificationMessageTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationEventMessageTransformer(builderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationTerminationMessageTransformer(builderFactory));
    }
}

