/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.dispatcher.delegate;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.function.Function;
import okhttp3.Response;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.protocol.dsp.spi.dispatcher.DspHttpDispatcherDelegate;
import org.eclipse.edc.protocol.dsp.spi.serialization.JsonLdRemoteMessageSerializer;
import org.eclipse.edc.spi.EdcException;

public class ContractRequestMessageHttpDelegate
extends DspHttpDispatcherDelegate<ContractRequestMessage, Object> {
    private final ObjectMapper mapper;
    private final JsonLd jsonLdService;

    public ContractRequestMessageHttpDelegate(JsonLdRemoteMessageSerializer serializer, ObjectMapper mapper, JsonLd jsonLdService) {
        this.mapper = mapper;
        this.jsonLdService = jsonLdService;
    }

    public Function<Response, Object> parseResponse() {
        return response -> {
            try {
                JsonObject jsonObject = (JsonObject)this.mapper.readValue(response.body().bytes(), JsonObject.class);
                return this.jsonLdService.expand(jsonObject).map(jo -> jo).orElseThrow(failure -> new EdcException(failure.getFailureDetail()));
            }
            catch (NullPointerException e) {
                throw new EdcException("Failed to read response body, as body was null.");
            }
            catch (IndexOutOfBoundsException e) {
                throw new EdcException("Failed to expand JSON-LD in response body.", (Throwable)e);
            }
            catch (IOException e) {
                throw new EdcException("Failed to read response body.", (Throwable)e);
            }
        };
    }
}

