/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.dispatcher;

import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreementVerificationMessage;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiationTerminationMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.protocol.dsp.dispatcher.PostDspHttpRequestFactory;
import org.eclipse.edc.protocol.dsp.negotiation.dispatcher.delegate.ContractAgreementMessageHttpDelegate;
import org.eclipse.edc.protocol.dsp.negotiation.dispatcher.delegate.ContractAgreementVerificationMessageHttpDelegate;
import org.eclipse.edc.protocol.dsp.negotiation.dispatcher.delegate.ContractNegotiationEventMessageHttpDelegate;
import org.eclipse.edc.protocol.dsp.negotiation.dispatcher.delegate.ContractNegotiationTerminationMessageHttpDelegate;
import org.eclipse.edc.protocol.dsp.negotiation.dispatcher.delegate.ContractOfferMessageHttpDelegate;
import org.eclipse.edc.protocol.dsp.negotiation.dispatcher.delegate.ContractRequestMessageHttpDelegate;
import org.eclipse.edc.protocol.dsp.spi.dispatcher.DspHttpDispatcherDelegate;
import org.eclipse.edc.protocol.dsp.spi.dispatcher.DspHttpRemoteMessageDispatcher;
import org.eclipse.edc.protocol.dsp.spi.dispatcher.DspHttpRequestFactory;
import org.eclipse.edc.protocol.dsp.spi.serialization.JsonLdRemoteMessageSerializer;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;

@Extension(value="Dataspace Protocol Negotiation HTTP Dispatcher Extension")
public class DspNegotiationHttpDispatcherExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Negotiation HTTP Dispatcher Extension";
    @Inject
    private DspHttpRemoteMessageDispatcher messageDispatcher;
    @Inject
    private TypeManager typeManager;
    @Inject
    private JsonLdRemoteMessageSerializer remoteMessageSerializer;
    @Inject
    private JsonLd jsonLdService;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.messageDispatcher.registerMessage(ContractAgreementMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, m -> "/negotiations/" + m.getProcessId() + "/agreement"), (DspHttpDispatcherDelegate)new ContractAgreementMessageHttpDelegate(this.remoteMessageSerializer));
        this.messageDispatcher.registerMessage(ContractAgreementVerificationMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, m -> "/negotiations/" + m.getProcessId() + "/agreement/verification"), (DspHttpDispatcherDelegate)new ContractAgreementVerificationMessageHttpDelegate(this.remoteMessageSerializer));
        this.messageDispatcher.registerMessage(ContractNegotiationEventMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, m -> "/negotiations/" + m.getProcessId() + "/events"), (DspHttpDispatcherDelegate)new ContractNegotiationEventMessageHttpDelegate(this.remoteMessageSerializer));
        this.messageDispatcher.registerMessage(ContractNegotiationTerminationMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, m -> "/negotiations/" + m.getProcessId() + "/termination"), (DspHttpDispatcherDelegate)new ContractNegotiationTerminationMessageHttpDelegate(this.remoteMessageSerializer));
        this.messageDispatcher.registerMessage(ContractRequestMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, m -> {
            if (m.getType() == ContractRequestMessage.Type.INITIAL) {
                return "/negotiations/request";
            }
            return "/negotiations/" + m.getProcessId() + "/request";
        }), (DspHttpDispatcherDelegate)new ContractRequestMessageHttpDelegate(this.remoteMessageSerializer, this.typeManager.getMapper("json-ld"), this.jsonLdService));
        this.messageDispatcher.registerMessage(ContractOfferMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, m -> "/negotiations/" + m.getProcessId() + "/offers"), (DspHttpDispatcherDelegate)new ContractOfferMessageHttpDelegate(this.remoteMessageSerializer));
    }
}

