/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.http.api;

import org.eclipse.edc.connector.controlplane.services.spi.contractnegotiation.ContractNegotiationProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.ProtocolVersionRegistry;
import org.eclipse.edc.protocol.dsp.http.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.negotiation.http.api.controller.DspNegotiationApiController;
import org.eclipse.edc.protocol.dsp.negotiation.http.api.controller.DspNegotiationApiController20241;
import org.eclipse.edc.protocol.dsp.negotiation.http.api.validation.ContractAgreementMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.http.api.validation.ContractAgreementVerificationMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.http.api.validation.ContractNegotiationEventMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.http.api.validation.ContractNegotiationTerminationMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.http.api.validation.ContractOfferMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.http.api.validation.ContractRequestMessageValidator;
import org.eclipse.edc.protocol.dsp.spi.version.DspVersions;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Dataspace Protocol Negotiation Api")
public class DspNegotiationApiExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Negotiation Api";
    @Inject
    private WebService webService;
    @Inject
    private ContractNegotiationProtocolService protocolService;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;
    @Inject
    private DspRequestHandler dspRequestHandler;
    @Inject
    private ProtocolVersionRegistry versionRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractRequestMessage", ContractRequestMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractOfferMessage", ContractOfferMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractNegotiationEventMessage", ContractNegotiationEventMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractAgreementMessage", ContractAgreementMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractAgreementVerificationMessage", ContractAgreementVerificationMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractNegotiationTerminationMessage", ContractNegotiationTerminationMessageValidator.instance());
        this.webService.registerResource("protocol", (Object)new DspNegotiationApiController(this.protocolService, this.dspRequestHandler));
        this.webService.registerResource("protocol", (Object)new DspNegotiationApiController20241(this.protocolService, this.dspRequestHandler));
        this.versionRegistry.register(DspVersions.V_2024_1);
    }
}

