/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.http.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.eclipse.edc.connector.controlplane.services.spi.contractnegotiation.ContractNegotiationProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.ProtocolVersionRegistry;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.protocol.dsp.http.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.negotiation.http.api.controller.DspNegotiationApiController;
import org.eclipse.edc.protocol.dsp.negotiation.http.api.controller.DspNegotiationApiController20241;
import org.eclipse.edc.protocol.dsp.negotiation.validation.ContractAgreementMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.validation.ContractAgreementVerificationMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.validation.ContractNegotiationEventMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.validation.ContractNegotiationTerminationMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.validation.ContractOfferMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.validation.ContractRequestMessageValidator;
import org.eclipse.edc.protocol.dsp.spi.type.DspConstants;
import org.eclipse.edc.protocol.dsp.spi.version.DspVersions;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.jersey.providers.jsonld.JerseyJsonLdInterceptor;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Dataspace Protocol Negotiation Api")
public class DspNegotiationApiExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Negotiation Api";
    @Inject
    private WebService webService;
    @Inject
    private ContractNegotiationProtocolService protocolService;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;
    @Inject
    private DspRequestHandler dspRequestHandler;
    @Inject
    private ProtocolVersionRegistry versionRegistry;
    @Inject
    private JsonLd jsonLd;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        ObjectMapper jsonLdMapper = this.typeManager.getMapper("json-ld");
        this.registerValidators(DspConstants.DSP_NAMESPACE_V_08);
        this.registerValidators(DspConstants.DSP_NAMESPACE_V_2024_1);
        this.webService.registerResource("protocol", (Object)new DspNegotiationApiController(this.protocolService, this.dspRequestHandler));
        this.webService.registerResource("protocol", (Object)new DspNegotiationApiController20241(this.protocolService, this.dspRequestHandler));
        this.webService.registerDynamicResource("protocol", DspNegotiationApiController.class, (Object)new JerseyJsonLdInterceptor(this.jsonLd, jsonLdMapper, "DSP:v0.8"));
        this.webService.registerDynamicResource("protocol", DspNegotiationApiController20241.class, (Object)new JerseyJsonLdInterceptor(this.jsonLd, jsonLdMapper, "DSP:2024/1"));
        this.versionRegistry.register(DspVersions.V_2024_1);
        this.versionRegistry.register(DspVersions.V_08);
    }

    private void registerValidators(JsonLdNamespace namespace) {
        this.validatorRegistry.register(namespace.toIri("ContractRequestMessage"), ContractRequestMessageValidator.instance((JsonLdNamespace)namespace));
        this.validatorRegistry.register(namespace.toIri("ContractOfferMessage"), ContractOfferMessageValidator.instance((JsonLdNamespace)namespace));
        this.validatorRegistry.register(namespace.toIri("ContractNegotiationEventMessage"), ContractNegotiationEventMessageValidator.instance((JsonLdNamespace)namespace));
        this.validatorRegistry.register(namespace.toIri("ContractAgreementMessage"), ContractAgreementMessageValidator.instance((JsonLdNamespace)namespace));
        this.validatorRegistry.register(namespace.toIri("ContractAgreementVerificationMessage"), ContractAgreementVerificationMessageValidator.instance((JsonLdNamespace)namespace));
        this.validatorRegistry.register(namespace.toIri("ContractNegotiationTerminationMessage"), ContractNegotiationTerminationMessageValidator.instance((JsonLdNamespace)namespace));
    }
}

