/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.http.api.controller;

import jakarta.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreementVerificationMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationError;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationTerminationMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.connector.controlplane.services.spi.contractnegotiation.ContractNegotiationProtocolService;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.protocol.dsp.http.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.http.spi.message.GetDspRequest;
import org.eclipse.edc.protocol.dsp.http.spi.message.PostDspRequest;

public abstract class BaseDspNegotiationApiController {
    private final DspRequestHandler dspRequestHandler;
    private final String protocol;
    private final JsonLdNamespace namespace;
    private final ContractNegotiationProtocolService protocolService;

    public BaseDspNegotiationApiController(ContractNegotiationProtocolService protocolService, DspRequestHandler dspRequestHandler, String protocol, JsonLdNamespace namespace) {
        this.protocolService = protocolService;
        this.dspRequestHandler = dspRequestHandler;
        this.protocol = protocol;
        this.namespace = namespace;
    }

    @GET
    @Path(value="{id}")
    public Response getNegotiation(@PathParam(value="id") String id, @HeaderParam(value="Authorization") String token) {
        GetDspRequest request = (GetDspRequest)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)GetDspRequest.Builder.newInstance(ContractNegotiation.class, ContractNegotiationError.class).id(id).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).findById(arg_0, arg_1))).errorProvider(ContractNegotiationError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.getResource(request);
    }

    @POST
    @Path(value="request")
    public Response initialContractRequest(JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractRequestMessage.class, ContractNegotiation.class, ContractNegotiationError.class).expectedMessageType(this.namespace.toIri("ContractRequestMessage")).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyRequested(arg_0, arg_1))).errorProvider(ContractNegotiationError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.createResource(request);
    }

    @POST
    @Path(value="offer")
    public Response initialContractOffer(JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractOfferMessage.class, ContractNegotiation.class, ContractNegotiationError.class).expectedMessageType(this.namespace.toIri("ContractOfferMessage")).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyOffered(arg_0, arg_1))).errorProvider(ContractNegotiationError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.createResource(request);
    }

    @POST
    @Path(value="{id}/request")
    public Response contractRequest(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractRequestMessage.class, ContractNegotiation.class, ContractNegotiationError.class).expectedMessageType(this.namespace.toIri("ContractRequestMessage")).processId(id).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyRequested(arg_0, arg_1))).errorProvider(ContractNegotiationError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/events")
    public Response createEvent(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractNegotiationEventMessage.class, ContractNegotiation.class, ContractNegotiationError.class).expectedMessageType(this.namespace.toIri("ContractNegotiationEventMessage")).processId(id).message(jsonObject).token(token)).serviceCall((message, claimToken) -> switch (message.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ContractNegotiationEventMessage.Type.FINALIZED -> this.protocolService.notifyFinalized(message, claimToken);
            case ContractNegotiationEventMessage.Type.ACCEPTED -> this.protocolService.notifyAccepted(message, claimToken);
        })).errorProvider(ContractNegotiationError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/agreement/verification")
    public Response verifyAgreement(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractAgreementVerificationMessage.class, ContractNegotiation.class, ContractNegotiationError.class).expectedMessageType(this.namespace.toIri("ContractAgreementVerificationMessage")).processId(id).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyVerified(arg_0, arg_1))).errorProvider(ContractNegotiationError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/termination")
    public Response terminateNegotiation(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractNegotiationTerminationMessage.class, ContractNegotiation.class, ContractNegotiationError.class).expectedMessageType(this.namespace.toIri("ContractNegotiationTerminationMessage")).processId(id).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyTerminated(arg_0, arg_1))).errorProvider(ContractNegotiationError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/offer")
    public Response providerOffer(@PathParam(value="id") String id, JsonObject body, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractOfferMessage.class, ContractNegotiation.class, ContractNegotiationError.class).expectedMessageType(this.namespace.toIri("ContractOfferMessage")).processId(id).message(body).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyOffered(arg_0, arg_1))).errorProvider(ContractNegotiationError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/agreement")
    public Response createAgreement(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractAgreementMessage.class, ContractNegotiation.class, ContractNegotiationError.class).expectedMessageType(this.namespace.toIri("ContractAgreementMessage")).processId(id).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyAgreed(arg_0, arg_1))).errorProvider(ContractNegotiationError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.updateResource(request);
    }
}

