/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.api.controller;

import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreementVerificationMessage;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiationTerminationMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.connector.spi.contractnegotiation.ContractNegotiationProtocolService;
import org.eclipse.edc.protocol.dsp.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.spi.message.GetDspRequest;
import org.eclipse.edc.protocol.dsp.spi.message.PostDspRequest;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.jetbrains.annotations.NotNull;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/negotiations/")
public class DspNegotiationApiController {
    private final TypeTransformerRegistry transformerRegistry;
    private final DspRequestHandler dspRequestHandler;
    private final Monitor monitor;
    private final ContractNegotiationProtocolService protocolService;

    public DspNegotiationApiController(TypeTransformerRegistry transformerRegistry, ContractNegotiationProtocolService protocolService, Monitor monitor, DspRequestHandler dspRequestHandler) {
        this.monitor = monitor;
        this.protocolService = protocolService;
        this.transformerRegistry = transformerRegistry;
        this.dspRequestHandler = dspRequestHandler;
    }

    @GET
    @Path(value="{id}")
    public Response getNegotiation(@PathParam(value="id") String id, @HeaderParam(value="Authorization") String token) {
        GetDspRequest request = (GetDspRequest)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)GetDspRequest.Builder.newInstance(ContractNegotiation.class).id(id).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).findById(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/ContractNegotiationError")).build();
        return this.dspRequestHandler.getResource(request);
    }

    @POST
    @Path(value="request")
    public Response initiateNegotiation(JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractRequestMessage.class, ContractNegotiation.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractRequestMessage").message(jsonObject).token(token)).serviceCall(this::validateAndProcessRequest)).errorType("https://w3id.org/dspace/v0.8/ContractNegotiationError")).build();
        return this.dspRequestHandler.createResource(request);
    }

    @POST
    @Path(value="{id}/request")
    public Response consumerOffer(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractRequestMessage.class, ContractNegotiation.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractRequestMessage").processId(id).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyRequested(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/ContractNegotiationError")).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/events")
    public Response createEvent(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractNegotiationEventMessage.class, ContractNegotiation.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractNegotiationEventMessage").processId(id).message(jsonObject).token(token)).serviceCall((message, claimToken) -> switch (message.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ContractNegotiationEventMessage.Type.FINALIZED -> this.protocolService.notifyFinalized(message, claimToken);
            case ContractNegotiationEventMessage.Type.ACCEPTED -> this.protocolService.notifyAccepted(message, claimToken);
        })).errorType("https://w3id.org/dspace/v0.8/ContractNegotiationError")).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/agreement/verification")
    public Response verifyAgreement(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractAgreementVerificationMessage.class, ContractNegotiation.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractAgreementVerificationMessage").processId(id).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyVerified(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/ContractNegotiationError")).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/termination")
    public Response terminateNegotiation(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractNegotiationTerminationMessage.class, ContractNegotiation.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractNegotiationTerminationMessage").processId(id).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyTerminated(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/ContractNegotiationError")).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/offers")
    public Response providerOffer(@PathParam(value="id") String id, JsonObject body, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractOfferMessage.class, ContractNegotiation.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractOfferMessage").processId(id).message(body).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyOffered(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/ContractNegotiationError")).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @POST
    @Path(value="{id}/agreement")
    public Response createAgreement(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(ContractAgreementMessage.class, ContractNegotiation.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractAgreementMessage").processId(id).message(jsonObject).token(token)).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyAgreed(arg_0, arg_1))).errorType("https://w3id.org/dspace/v0.8/ContractNegotiationError")).build();
        return this.dspRequestHandler.updateResource(request);
    }

    @NotNull
    private ServiceResult<ContractNegotiation> validateAndProcessRequest(ContractRequestMessage message, ClaimToken claimToken) {
        if (message.getCallbackAddress() == null) {
            throw new InvalidRequestException(String.format("ContractRequestMessage must contain a '%s' property", "https://w3id.org/dspace/v0.8/callbackAddress"));
        }
        return this.protocolService.notifyRequested(message, claimToken);
    }
}

