/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.api;

import org.eclipse.edc.connector.spi.contractnegotiation.ContractNegotiationProtocolService;
import org.eclipse.edc.protocol.dsp.api.configuration.DspApiConfiguration;
import org.eclipse.edc.protocol.dsp.negotiation.api.controller.DspNegotiationApiController;
import org.eclipse.edc.protocol.dsp.negotiation.api.validation.ContractAgreementMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.api.validation.ContractAgreementVerificationMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.api.validation.ContractNegotiationEventMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.api.validation.ContractNegotiationTerminationMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.api.validation.ContractOfferMessageValidator;
import org.eclipse.edc.protocol.dsp.negotiation.api.validation.ContractRequestMessageValidator;
import org.eclipse.edc.protocol.dsp.spi.message.DspRequestHandler;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Dataspace Protocol Negotiation Api Extension")
public class DspNegotiationApiExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Negotiation Api Extension";
    @Inject
    private WebService webService;
    @Inject
    private DspApiConfiguration apiConfiguration;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private Monitor monitor;
    @Inject
    private ContractNegotiationProtocolService protocolService;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;
    @Inject
    private DspRequestHandler dspRequestHandler;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractRequestMessage", ContractRequestMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractOfferMessage", ContractOfferMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractNegotiationEventMessage", ContractNegotiationEventMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractAgreementMessage", ContractAgreementMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractAgreementVerificationMessage", ContractAgreementVerificationMessageValidator.instance());
        this.validatorRegistry.register("https://w3id.org/dspace/v0.8/ContractNegotiationTerminationMessage", ContractNegotiationTerminationMessageValidator.instance());
        DspNegotiationApiController controller = new DspNegotiationApiController(this.transformerRegistry, this.protocolService, this.monitor, this.dspRequestHandler);
        this.webService.registerResource(this.apiConfiguration.getContextAlias(), (Object)controller);
    }
}

