/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.api.controller;

import jakarta.json.JsonObject;
import java.util.function.BiFunction;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.contract.spi.types.protocol.ContractRemoteMessage;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.iam.ClaimToken;

class MessageSpec<M extends ContractRemoteMessage> {
    private JsonObject message;
    private String processId;
    private String token;
    private String expectedMessageType;
    private Class<M> messageClass;
    private BiFunction<M, ClaimToken, ServiceResult<ContractNegotiation>> serviceCall;

    public JsonObject getMessage() {
        return this.message;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getToken() {
        return this.token;
    }

    public String getExpectedMessageType() {
        return this.expectedMessageType;
    }

    public Class<M> getMessageClass() {
        return this.messageClass;
    }

    public BiFunction<M, ClaimToken, ServiceResult<ContractNegotiation>> getServiceCall() {
        return this.serviceCall;
    }

    private MessageSpec(Class<M> messageClass) {
        this.messageClass = messageClass;
    }

    public static class Builder<M extends ContractRemoteMessage> {
        private MessageSpec<M> spec;

        public static <M extends ContractRemoteMessage> Builder<M> newInstance(Class<M> messageClass) {
            return new Builder<M>(messageClass);
        }

        public Builder<M> message(JsonObject message) {
            this.spec.message = message;
            return this;
        }

        public Builder<M> processId(String processId) {
            this.spec.processId = processId;
            return this;
        }

        public Builder<M> token(String token) {
            this.spec.token = token;
            return this;
        }

        public Builder<M> expectedMessageType(String expectedMessageType) {
            this.spec.expectedMessageType = expectedMessageType;
            return this;
        }

        public Builder<M> serviceCall(BiFunction<M, ClaimToken, ServiceResult<ContractNegotiation>> serviceCall) {
            this.spec.serviceCall = serviceCall;
            return this;
        }

        public MessageSpec<M> build() {
            return this.spec;
        }

        private Builder(Class<M> messageClass) {
            this.spec = new MessageSpec<M>(messageClass);
        }
    }
}

