/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.api.controller;

import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreementVerificationMessage;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiationTerminationMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.connector.contract.spi.types.protocol.ContractRemoteMessage;
import org.eclipse.edc.connector.spi.contractnegotiation.ContractNegotiationProtocolService;
import org.eclipse.edc.jsonld.spi.TypeUtil;
import org.eclipse.edc.protocol.dsp.api.configuration.error.DspErrorResponse;
import org.eclipse.edc.protocol.dsp.negotiation.api.controller.MessageSpec;
import org.eclipse.edc.service.spi.result.ServiceFailure;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.iam.IdentityService;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/negotiations/")
public class DspNegotiationApiController {
    private final IdentityService identityService;
    private final TypeTransformerRegistry transformerRegistry;
    private final String callbackAddress;
    private final Monitor monitor;
    private final ContractNegotiationProtocolService protocolService;

    public DspNegotiationApiController(String callbackAddress, IdentityService identityService, TypeTransformerRegistry transformerRegistry, ContractNegotiationProtocolService protocolService, Monitor monitor) {
        this.callbackAddress = callbackAddress;
        this.identityService = identityService;
        this.monitor = monitor;
        this.protocolService = protocolService;
        this.transformerRegistry = transformerRegistry;
    }

    @GET
    @Path(value="{id}")
    public Response getNegotiation(@PathParam(value="id") String id, @HeaderParam(value="Authorization") String token) {
        Result<ClaimToken> claimTokenResult = this.checkAndReturnAuthToken(token);
        if (claimTokenResult.failed()) {
            return this.error().processId(id).unauthorized();
        }
        return (Response)this.protocolService.findById(id, (ClaimToken)claimTokenResult.getContent()).map(this::createNegotiationResponse).orElse(this.createErrorResponse(id));
    }

    @POST
    @Path(value="request")
    public Response initiateNegotiation(JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        ServiceResult<ContractNegotiation> negotiationResult = this.handleMessage(MessageSpec.Builder.newInstance(ContractRequestMessage.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractRequestMessage").message(jsonObject).token(token).serviceCall(this::validateAndProcessRequest).build());
        if (negotiationResult.failed()) {
            return this.error().from((ServiceFailure)negotiationResult.getFailure());
        }
        return this.createNegotiationResponse((ContractNegotiation)negotiationResult.getContent());
    }

    @POST
    @Path(value="{id}/request")
    public Response consumerOffer(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        return (Response)this.handleMessage(MessageSpec.Builder.newInstance(ContractRequestMessage.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractRequestMessage").processId(id).message(jsonObject).token(token).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyRequested(arg_0, arg_1)).build()).map(cn -> Response.ok().build()).orElse(this.createErrorResponse(id));
    }

    @POST
    @Path(value="{id}/events")
    public Response createEvent(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        return (Response)this.handleMessage(MessageSpec.Builder.newInstance(ContractNegotiationEventMessage.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractNegotiationEventMessage").processId(id).message(jsonObject).token(token).serviceCall((message, claimToken) -> switch (message.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ContractNegotiationEventMessage.Type.FINALIZED -> this.protocolService.notifyFinalized(message, claimToken);
            case ContractNegotiationEventMessage.Type.ACCEPTED -> this.protocolService.notifyAccepted(message, claimToken);
        }).build()).map(cn -> Response.ok().build()).orElse(this.createErrorResponse(id));
    }

    @POST
    @Path(value="{id}/agreement/verification")
    public Response verifyAgreement(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        return (Response)this.handleMessage(MessageSpec.Builder.newInstance(ContractAgreementVerificationMessage.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractAgreementVerificationMessage").processId(id).message(jsonObject).token(token).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyVerified(arg_0, arg_1)).build()).map(cn -> Response.ok().build()).orElse(this.createErrorResponse(id));
    }

    @POST
    @Path(value="{id}/termination")
    public Response terminateNegotiation(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        return (Response)this.handleMessage(MessageSpec.Builder.newInstance(ContractNegotiationTerminationMessage.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractNegotiationTerminationMessage").processId(id).message(jsonObject).token(token).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyTerminated(arg_0, arg_1)).build()).map(cn -> Response.ok().build()).orElse(this.createErrorResponse(id));
    }

    @POST
    @Path(value="{id}/offers")
    public Response providerOffer(@PathParam(value="id") String id, JsonObject body, @HeaderParam(value="Authorization") String token) {
        return (Response)this.handleMessage(MessageSpec.Builder.newInstance(ContractOfferMessage.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractOfferMessage").processId(id).message(body).token(token).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyOffered(arg_0, arg_1)).build()).map(cn -> Response.ok().build()).orElse(this.createErrorResponse(id));
    }

    @POST
    @Path(value="{id}/agreement")
    public Response createAgreement(@PathParam(value="id") String id, JsonObject jsonObject, @HeaderParam(value="Authorization") String token) {
        return (Response)this.handleMessage(MessageSpec.Builder.newInstance(ContractAgreementMessage.class).expectedMessageType("https://w3id.org/dspace/v0.8/ContractAgreementMessage").processId(id).message(jsonObject).token(token).serviceCall((arg_0, arg_1) -> ((ContractNegotiationProtocolService)this.protocolService).notifyAgreed(arg_0, arg_1)).build()).map(cn -> Response.ok().build()).orElse(this.createErrorResponse(id));
    }

    private <M extends ContractRemoteMessage> ServiceResult<ContractNegotiation> handleMessage(MessageSpec<M> messageSpec) {
        this.monitor.debug(() -> String.format("DSP: Incoming %s for contract negotiation process%s", messageSpec.getMessageClass().getSimpleName(), messageSpec.getProcessId() != null ? ": " + messageSpec.getProcessId() : ""), new Throwable[0]);
        Result<ClaimToken> claimToken = this.checkAndReturnAuthToken(messageSpec.getToken());
        if (claimToken.failed()) {
            return ServiceResult.unauthorized((List)claimToken.getFailureMessages());
        }
        if (!TypeUtil.isOfExpectedType((JsonObject)messageSpec.getMessage(), (String)messageSpec.getExpectedMessageType())) {
            return ServiceResult.badRequest((String[])new String[]{String.format("Request body was not of expected type: %s", messageSpec.getExpectedMessageType())});
        }
        Result ingressResult = (Result)this.transformerRegistry.transform((Object)messageSpec.getMessage(), messageSpec.getMessageClass()).compose(contractNegotiationMessage -> {
            contractNegotiationMessage.setProtocol("dataspace-protocol-http");
            return this.validateProcessId(messageSpec.getProcessId(), contractNegotiationMessage);
        });
        if (ingressResult.failed()) {
            return ServiceResult.badRequest((String[])new String[]{String.format("Failed to read request body: %s", ingressResult.getFailureDetail())});
        }
        return messageSpec.getServiceCall().apply((ContractRemoteMessage)ingressResult.getContent(), (ClaimToken)claimToken.getContent());
    }

    @NotNull
    private ServiceResult<ContractNegotiation> validateAndProcessRequest(ContractRequestMessage message, ClaimToken claimToken) {
        if (message.getCallbackAddress() == null) {
            throw new InvalidRequestException(String.format("ContractRequestMessage must contain a '%s' property", "https://w3id.org/dspace/v0.8/callbackAddress"));
        }
        return this.protocolService.notifyRequested(message, claimToken);
    }

    private Result<ClaimToken> checkAndReturnAuthToken(String token) {
        TokenRepresentation tokenRepresentation = TokenRepresentation.Builder.newInstance().token(token).build();
        return this.identityService.verifyJwtToken(tokenRepresentation, this.callbackAddress);
    }

    private <M extends ContractRemoteMessage> Result<M> validateProcessId(@Nullable String expected, M actual) {
        if (expected == null) {
            return Result.success(actual);
        }
        return Objects.equals(expected, actual.getProcessId()) ? Result.success(actual) : Result.failure((String)String.format("Invalid process ID. Expected: %s, actual: %s", expected, actual));
    }

    private Response createNegotiationResponse(ContractNegotiation negotiation) {
        return (Response)this.transformerRegistry.transform((Object)negotiation, JsonObject.class).map(transformedJson -> Response.ok().type("application/json").entity(transformedJson).build()).orElse(failure -> {
            UUID errorCode = UUID.randomUUID();
            this.monitor.warning(String.format("Error transforming negotiation, error id %s: %s", errorCode, failure.getFailureDetail()), new Throwable[0]);
            String processId = negotiation.getCorrelationId();
            return this.error().processId(processId).message(String.format("Error code %s", errorCode)).internalServerError();
        });
    }

    @NotNull
    private Function<ServiceFailure, Response> createErrorResponse(String id) {
        return failure -> this.error().processId(id).from(failure);
    }

    @NotNull
    private DspErrorResponse error() {
        return DspErrorResponse.type((String)"https://w3id.org/dspace/v0.8/ContractNegotiationError");
    }
}

