/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.spi.error;

import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edc.protocol.dsp.DspError;
import org.eclipse.edc.spi.result.ServiceFailure;
import org.jetbrains.annotations.NotNull;

public class DspErrorResponse {
    private final String type;
    private String processId;
    private final List<String> messages = new ArrayList<String>();

    public static DspErrorResponse type(String type) {
        return new DspErrorResponse(type);
    }

    public DspErrorResponse(String type) {
        this.type = type;
    }

    public Response from(ServiceFailure failure) {
        Response.Status code = this.getHttpStatus(failure);
        return this.internalBuild(code, failure.getMessages());
    }

    public Response badRequest() {
        return this.internalBuild(Response.Status.BAD_REQUEST, List.of("Bad request."));
    }

    public Response notImplemented() {
        return this.internalBuild(Response.Status.NOT_IMPLEMENTED, List.of("Currently not supported."));
    }

    public Response internalServerError() {
        return this.internalBuild(Response.Status.INTERNAL_SERVER_ERROR, Collections.emptyList());
    }

    public DspErrorResponse processId(String processId) {
        this.processId = processId;
        return this;
    }

    public DspErrorResponse message(String message) {
        this.messages.add(message);
        return this;
    }

    private Response internalBuild(Response.Status code, List<String> baseMessages) {
        DspError.Builder builder = DspError.Builder.newInstance().type(this.type).code(Integer.toString(code.getStatusCode()));
        if (this.messages.isEmpty()) {
            builder.messages(baseMessages);
        } else {
            builder.messages(this.messages);
        }
        if (this.processId != null) {
            builder.processId(this.processId);
        }
        return Response.status((Response.Status)code).type("application/json").entity((Object)builder.build().toJson()).build();
    }

    @NotNull
    private Response.Status getHttpStatus(ServiceFailure failure) {
        return switch (failure.getReason()) {
            case ServiceFailure.Reason.UNAUTHORIZED -> Response.Status.UNAUTHORIZED;
            case ServiceFailure.Reason.CONFLICT -> Response.Status.CONFLICT;
            case ServiceFailure.Reason.NOT_FOUND -> Response.Status.NOT_FOUND;
            default -> Response.Status.BAD_REQUEST;
        };
    }
}

