/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.spi.message;

import java.util.Objects;
import java.util.function.BiFunction;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.result.ServiceResult;

public class DspRequest<I, R> {
    protected final Class<R> resultClass;
    protected final Class<I> inputClass;
    protected String token;
    protected String errorType;
    protected BiFunction<I, ClaimToken, ServiceResult<R>> serviceCall;

    public DspRequest(Class<I> inputClass, Class<R> resultClass) {
        this.inputClass = inputClass;
        this.resultClass = resultClass;
    }

    public String getToken() {
        return this.token;
    }

    public Class<I> getInputClass() {
        return this.inputClass;
    }

    public Class<R> getResultClass() {
        return this.resultClass;
    }

    public BiFunction<I, ClaimToken, ServiceResult<R>> getServiceCall() {
        return this.serviceCall;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public static abstract class Builder<I, R, M extends DspRequest<I, R>, B extends Builder<I, R, M, B>> {
        protected final M message;

        protected Builder(M message) {
            this.message = message;
        }

        public B token(String token) {
            ((DspRequest)this.message).token = token;
            return this.self();
        }

        public B serviceCall(BiFunction<I, ClaimToken, ServiceResult<R>> serviceCall) {
            ((DspRequest)this.message).serviceCall = serviceCall;
            return this.self();
        }

        public B errorType(String errorType) {
            ((DspRequest)this.message).errorType = errorType;
            return this.self();
        }

        public M build() {
            Objects.requireNonNull(((DspRequest)this.message).token);
            Objects.requireNonNull(((DspRequest)this.message).serviceCall);
            Objects.requireNonNull(((DspRequest)this.message).errorType);
            return this.message;
        }

        protected abstract B self();
    }
}

