/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.spi.dispatcher;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;

public abstract class DspHttpDispatcherDelegate<M extends RemoteMessage, R> {
    protected DspHttpDispatcherDelegate() {
    }

    public Function<Response, StatusResult<R>> handleResponse() {
        return response -> {
            if (response.isSuccessful()) {
                R responsePayload = this.parseResponse().apply((Response)response);
                return StatusResult.success(responsePayload);
            }
            String responseBody = Optional.ofNullable(response.body()).map(this::asString).orElse("Response body is null");
            ResponseStatus status = response.code() >= 400 && response.code() < 500 ? ResponseStatus.FATAL_ERROR : ResponseStatus.ERROR_RETRY;
            return StatusResult.failure((ResponseStatus)status, (String)responseBody);
        };
    }

    protected abstract Function<Response, R> parseResponse();

    private String asString(ResponseBody it) {
        try {
            return it.string();
        }
        catch (IOException e) {
            return "Cannot read response body: " + e.getMessage();
        }
    }
}

