/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.http.spi.message;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.types.domain.message.ErrorMessage;

public class DspRequest<I, R, E extends ErrorMessage> {
    protected final Class<R> resultClass;
    protected final Class<I> inputClass;
    protected final Class<E> errorClass;
    protected String token;
    protected String protocol;
    protected BiFunction<I, TokenRepresentation, ServiceResult<R>> serviceCall;
    protected Supplier<? extends ErrorMessage.Builder<E, ?>> errorProvider;

    public DspRequest(Class<I> inputClass, Class<R> resultClass, Class<E> errorClass) {
        this.inputClass = inputClass;
        this.resultClass = resultClass;
        this.errorClass = errorClass;
    }

    public String getToken() {
        return this.token;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Class<I> getInputClass() {
        return this.inputClass;
    }

    public Class<R> getResultClass() {
        return this.resultClass;
    }

    public BiFunction<I, TokenRepresentation, ServiceResult<R>> getServiceCall() {
        return this.serviceCall;
    }

    public Supplier<? extends ErrorMessage.Builder<E, ?>> getErrorProvider() {
        return this.errorProvider;
    }

    public static abstract class Builder<I, R, M extends DspRequest<I, R, E>, E extends ErrorMessage, B extends Builder<I, R, M, E, B>> {
        protected final M message;

        protected Builder(M message) {
            this.message = message;
        }

        public B token(String token) {
            ((DspRequest)this.message).token = token;
            return this.self();
        }

        public B protocol(String protocol) {
            ((DspRequest)this.message).protocol = protocol;
            return this.self();
        }

        public B serviceCall(BiFunction<I, TokenRepresentation, ServiceResult<R>> serviceCall) {
            ((DspRequest)this.message).serviceCall = serviceCall;
            return this.self();
        }

        public B errorProvider(Supplier<? extends ErrorMessage.Builder<E, ?>> errorProvider) {
            ((DspRequest)this.message).errorProvider = errorProvider;
            return this.self();
        }

        public M build() {
            Objects.requireNonNull(((DspRequest)this.message).serviceCall);
            Objects.requireNonNull(((DspRequest)this.message).protocol);
            Objects.requireNonNull(((DspRequest)this.message).errorProvider);
            return this.message;
        }

        protected abstract B self();
    }
}

