/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.http.api.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.connector.controlplane.transform.edc.from.JsonObjectFromAssetTransformer;
import org.eclipse.edc.connector.controlplane.transform.edc.to.JsonObjectToAssetTransformer;
import org.eclipse.edc.connector.controlplane.transform.odrl.OdrlTransformersFactory;
import org.eclipse.edc.connector.controlplane.transform.odrl.from.JsonObjectFromPolicyTransformer;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.policy.model.AtomicConstraint;
import org.eclipse.edc.policy.model.LiteralExpression;
import org.eclipse.edc.protocol.dsp.http.spi.configuration.DspApiConfiguration;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.spi.agent.ParticipantIdMapper;
import org.eclipse.edc.spi.protocol.ProtocolWebhook;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.transform.transformer.dspace.from.JsonObjectFromDataAddressDspaceTransformer;
import org.eclipse.edc.transform.transformer.dspace.to.JsonObjectToDataAddressDspaceTransformer;
import org.eclipse.edc.transform.transformer.edc.from.JsonObjectFromCriterionTransformer;
import org.eclipse.edc.transform.transformer.edc.from.JsonObjectFromQuerySpecTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonObjectToCriterionTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonObjectToQuerySpecTransformer;
import org.eclipse.edc.transform.transformer.edc.to.JsonValueToGenericTypeTransformer;
import org.eclipse.edc.web.jersey.providers.jsonld.JerseyJsonLdInterceptor;
import org.eclipse.edc.web.jersey.providers.jsonld.ObjectMapperProvider;
import org.eclipse.edc.web.spi.WebServer;
import org.eclipse.edc.web.spi.WebService;
import org.eclipse.edc.web.spi.configuration.WebServiceConfiguration;
import org.eclipse.edc.web.spi.configuration.WebServiceConfigurer;
import org.eclipse.edc.web.spi.configuration.WebServiceSettings;

@Extension(value="Dataspace Protocol API Configuration Extension")
@Provides(value={DspApiConfiguration.class, ProtocolWebhook.class})
public class DspApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol API Configuration Extension";
    public static final String CONTEXT_ALIAS = "protocol";
    public static final String DEFAULT_DSP_CALLBACK_ADDRESS = "http://localhost:8282/api/v1/dsp";
    public static final String DSP_CALLBACK_ADDRESS = "edc.dsp.callback.address";
    public static final int DEFAULT_PROTOCOL_PORT = 8282;
    public static final String DEFAULT_PROTOCOL_API_PATH = "/api/v1/dsp";
    public static final WebServiceSettings SETTINGS = WebServiceSettings.Builder.newInstance().apiConfigKey("web.http.protocol").contextAlias("protocol").defaultPath("/api/v1/dsp").defaultPort(8282).name("Protocol API").build();
    @Inject
    private TypeManager typeManager;
    @Inject
    private WebService webService;
    @Inject
    private WebServer webServer;
    @Inject
    private WebServiceConfigurer configurator;
    @Inject
    private JsonLd jsonLd;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private ParticipantIdMapper participantIdMapper;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        WebServiceConfiguration config = this.configurator.configure(context, this.webServer, SETTINGS);
        String dspWebhookAddress = context.getSetting(DSP_CALLBACK_ADDRESS, DEFAULT_DSP_CALLBACK_ADDRESS);
        context.registerService(DspApiConfiguration.class, (Object)new DspApiConfiguration(config.getContextAlias(), dspWebhookAddress));
        context.registerService(ProtocolWebhook.class, () -> dspWebhookAddress);
        ObjectMapper jsonLdMapper = this.typeManager.getMapper("json-ld");
        this.jsonLd.registerNamespace("dcat", "http://www.w3.org/ns/dcat#", "DSP");
        this.jsonLd.registerNamespace("dct", "http://purl.org/dc/terms/", "DSP");
        this.jsonLd.registerNamespace("odrl", "http://www.w3.org/ns/odrl/2/", "DSP");
        this.jsonLd.registerNamespace("dspace", "https://w3id.org/dspace/v0.8/", "DSP");
        this.webService.registerResource(config.getContextAlias(), (Object)new ObjectMapperProvider(jsonLdMapper));
        this.webService.registerResource(config.getContextAlias(), (Object)new JerseyJsonLdInterceptor(this.jsonLd, jsonLdMapper, "DSP"));
        this.registerTransformers();
    }

    private void registerTransformers() {
        ObjectMapper mapper = this.typeManager.getMapper("json-ld");
        mapper.registerSubtypes(new Class[]{AtomicConstraint.class, LiteralExpression.class});
        JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(Map.of());
        TypeTransformerRegistry dspApiTransformerRegistry = this.transformerRegistry.forContext("dsp-api");
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromPolicyTransformer(jsonBuilderFactory, this.participantIdMapper));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromAssetTransformer(jsonBuilderFactory, mapper));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataAddressDspaceTransformer(jsonBuilderFactory, mapper));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromQuerySpecTransformer(jsonBuilderFactory));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromCriterionTransformer(jsonBuilderFactory, mapper));
        OdrlTransformersFactory.jsonObjectToOdrlTransformers((ParticipantIdMapper)this.participantIdMapper).forEach(arg_0 -> ((TypeTransformerRegistry)dspApiTransformerRegistry).register(arg_0));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonValueToGenericTypeTransformer(mapper));
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToAssetTransformer());
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToQuerySpecTransformer());
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToCriterionTransformer());
        dspApiTransformerRegistry.register((TypeTransformer)new JsonObjectToDataAddressDspaceTransformer());
    }
}

