/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.catalog.http.api.decorator;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.function.IntBinaryOperator;
import org.eclipse.edc.connector.controlplane.catalog.spi.Catalog;
import org.eclipse.edc.connector.controlplane.catalog.spi.CatalogRequestMessage;
import org.eclipse.edc.protocol.dsp.http.spi.message.ContinuationTokenSerDes;
import org.eclipse.edc.protocol.dsp.http.spi.message.ResponseDecorator;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.Result;

public class CatalogPaginationResponseDecorator
implements ResponseDecorator<CatalogRequestMessage, Catalog> {
    private static final String NEXT = "next";
    private static final String PREV = "prev";
    private final String requestUrl;
    private final ContinuationTokenSerDes continuationTokenSerDes;
    private final Monitor monitor;

    public CatalogPaginationResponseDecorator(String requestUrl, ContinuationTokenSerDes continuationTokenSerDes, Monitor monitor) {
        this.requestUrl = requestUrl;
        this.continuationTokenSerDes = continuationTokenSerDes;
        this.monitor = monitor;
    }

    public Response.ResponseBuilder decorate(Response.ResponseBuilder responseBuilder, CatalogRequestMessage requestBody, Catalog responseBody) {
        QuerySpec currentQuerySpec = requestBody.getQuerySpec();
        if (responseBody.getDatasets().size() == currentQuerySpec.getLimit()) {
            this.addLink(NEXT, responseBuilder, currentQuerySpec, (offset, limit) -> offset + limit);
        }
        if (currentQuerySpec.getOffset() >= currentQuerySpec.getLimit()) {
            this.addLink(PREV, responseBuilder, currentQuerySpec, (offset, limit) -> offset - limit);
        }
        return responseBuilder;
    }

    private void addLink(String rel, Response.ResponseBuilder responseBuilder, QuerySpec currentQuerySpec, IntBinaryOperator newOffsetOperator) {
        int newOffset = newOffsetOperator.applyAsInt(currentQuerySpec.getOffset(), currentQuerySpec.getLimit());
        ((Result)this.continuationTokenSerDes.serialize(currentQuerySpec.toBuilder().offset(Integer.valueOf(newOffset)).build()).onSuccess(token -> responseBuilder.link(URI.create(this.requestUrl + "?continuationToken=" + token), rel))).onFailure(failure -> this.monitor.warning("Cannot serialize continuationToken for catalog pagination: " + failure.getFailureDetail(), new Throwable[0]));
    }
}

