/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.catalog.http.api.decorator;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.protocol.dsp.http.spi.message.ContinuationTokenSerDes;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;

public class Base64continuationTokenSerDes
implements ContinuationTokenSerDes {
    private final TypeTransformerRegistry typeTransformerRegistry;
    private final JsonLd jsonLd;

    public Base64continuationTokenSerDes(TypeTransformerRegistry typeTransformerRegistry, JsonLd jsonLd) {
        this.typeTransformerRegistry = typeTransformerRegistry;
        this.jsonLd = jsonLd;
    }

    public Result<String> serialize(QuerySpec querySpec) {
        return (Result)this.typeTransformerRegistry.transform((Object)querySpec, JsonObject.class).map(Object::toString).map(String::getBytes).map(Base64.getEncoder()::encodeToString);
    }

    public Result<JsonObject> deserialize(String serialized) {
        try {
            byte[] decode = Base64.getDecoder().decode(serialized);
            JsonObject jsonObject = Json.createReader((InputStream)new ByteArrayInputStream(decode)).readObject();
            return this.jsonLd.expand(jsonObject);
        }
        catch (Exception e) {
            return Result.failure((String)("Cannot deserialize continuationToken: " + e.getMessage()));
        }
    }
}

