/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.catalog.http.api.controller;

import jakarta.json.JsonObject;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.eclipse.edc.connector.controlplane.catalog.spi.Catalog;
import org.eclipse.edc.connector.controlplane.catalog.spi.CatalogError;
import org.eclipse.edc.connector.controlplane.catalog.spi.CatalogRequestMessage;
import org.eclipse.edc.connector.controlplane.catalog.spi.Dataset;
import org.eclipse.edc.connector.controlplane.services.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.protocol.dsp.http.spi.message.ContinuationTokenManager;
import org.eclipse.edc.protocol.dsp.http.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.http.spi.message.GetDspRequest;
import org.eclipse.edc.protocol.dsp.http.spi.message.PostDspRequest;
import org.eclipse.edc.protocol.dsp.http.spi.message.ResponseDecorator;
import org.eclipse.edc.protocol.dsp.spi.type.DspConstants;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/catalog")
public class DspCatalogApiController {
    private final CatalogProtocolService service;
    private final DspRequestHandler dspRequestHandler;
    private final ContinuationTokenManager continuationTokenManager;
    private final String protocol;
    private final JsonLdNamespace namespace;

    public DspCatalogApiController(CatalogProtocolService service, DspRequestHandler dspRequestHandler, ContinuationTokenManager continuationTokenManager) {
        this(service, dspRequestHandler, continuationTokenManager, "dataspace-protocol-http", DspConstants.DSP_NAMESPACE_V_08);
    }

    public DspCatalogApiController(CatalogProtocolService service, DspRequestHandler dspRequestHandler, ContinuationTokenManager continuationTokenManager, String protocol, JsonLdNamespace namespace) {
        this.service = service;
        this.dspRequestHandler = dspRequestHandler;
        this.continuationTokenManager = continuationTokenManager;
        this.protocol = protocol;
        this.namespace = namespace;
    }

    @POST
    @Path(value="/request")
    public Response requestCatalog(JsonObject jsonObject, @HeaderParam(value="Authorization") String token, @Context UriInfo uriInfo, @QueryParam(value="continuationToken") String continuationToken) {
        JsonObject messageJson = continuationToken == null ? jsonObject : (JsonObject)this.continuationTokenManager.applyQueryFromToken(jsonObject, continuationToken).orElseThrow(f -> new BadRequestException(f.getFailureDetail()));
        PostDspRequest request = (PostDspRequest)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)((PostDspRequest.Builder)PostDspRequest.Builder.newInstance(CatalogRequestMessage.class, Catalog.class, CatalogError.class).token(token)).expectedMessageType(this.namespace.toIri("CatalogRequestMessage")).message(messageJson).serviceCall((arg_0, arg_1) -> ((CatalogProtocolService)this.service).getCatalog(arg_0, arg_1))).errorProvider(CatalogError.Builder::newInstance)).protocol(this.protocol)).build();
        ResponseDecorator responseDecorator = this.continuationTokenManager.createResponseDecorator(uriInfo.getAbsolutePath().toString());
        return this.dspRequestHandler.createResource(request, responseDecorator);
    }

    @GET
    @Path(value="/datasets/{id}")
    public Response getDataset(@PathParam(value="id") String id, @HeaderParam(value="Authorization") String token) {
        GetDspRequest request = (GetDspRequest)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)GetDspRequest.Builder.newInstance(Dataset.class, CatalogError.class).token(token)).id(id).serviceCall((arg_0, arg_1) -> ((CatalogProtocolService)this.service).getDataset(arg_0, arg_1))).errorProvider(CatalogError.Builder::newInstance)).protocol(this.protocol)).build();
        return this.dspRequestHandler.getResource(request);
    }
}

