/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.catalog.http.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.eclipse.edc.connector.controlplane.catalog.spi.DataService;
import org.eclipse.edc.connector.controlplane.catalog.spi.DataServiceRegistry;
import org.eclipse.edc.connector.controlplane.services.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.ProtocolVersionRegistry;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.protocol.dsp.catalog.http.api.controller.DspCatalogApiController;
import org.eclipse.edc.protocol.dsp.catalog.http.api.controller.DspCatalogApiController20241;
import org.eclipse.edc.protocol.dsp.catalog.http.api.decorator.Base64continuationTokenSerDes;
import org.eclipse.edc.protocol.dsp.catalog.http.api.decorator.ContinuationTokenManagerImpl;
import org.eclipse.edc.protocol.dsp.catalog.validation.CatalogRequestMessageValidator;
import org.eclipse.edc.protocol.dsp.http.spi.message.ContinuationTokenManager;
import org.eclipse.edc.protocol.dsp.http.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.spi.type.DspConstants;
import org.eclipse.edc.protocol.dsp.spi.version.DspVersions;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.protocol.ProtocolWebhook;
import org.eclipse.edc.spi.query.CriterionOperatorRegistry;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.jersey.providers.jsonld.JerseyJsonLdInterceptor;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Dataspace Protocol Catalog Extension")
public class DspCatalogApiExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Catalog Extension";
    @Inject
    private WebService webService;
    @Inject
    private ProtocolWebhook protocolWebhook;
    @Inject
    private CatalogProtocolService service;
    @Inject
    private DataServiceRegistry dataServiceRegistry;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;
    @Inject
    private DspRequestHandler dspRequestHandler;
    @Inject
    private CriterionOperatorRegistry criterionOperatorRegistry;
    @Inject
    private ProtocolVersionRegistry versionRegistry;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private Monitor monitor;
    @Inject
    private TypeManager typeManager;
    @Inject
    private JsonLd jsonLd;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        ObjectMapper jsonLdMapper = this.typeManager.getMapper("json-ld");
        this.registerValidators(DspConstants.DSP_NAMESPACE_V_08);
        this.registerValidators(DspConstants.DSP_NAMESPACE_V_2024_1);
        this.webService.registerResource("protocol", (Object)new DspCatalogApiController(this.service, this.dspRequestHandler, this.continuationTokenManager(this.monitor, "dsp-api:v0.8", DspConstants.DSP_NAMESPACE_V_08)));
        this.webService.registerResource("protocol", (Object)new DspCatalogApiController20241(this.service, this.dspRequestHandler, this.continuationTokenManager(this.monitor, "dsp-api:2024/1", DspConstants.DSP_NAMESPACE_V_2024_1)));
        this.webService.registerDynamicResource("protocol", DspCatalogApiController.class, (Object)new JerseyJsonLdInterceptor(this.jsonLd, jsonLdMapper, "DSP:v0.8"));
        this.webService.registerDynamicResource("protocol", DspCatalogApiController20241.class, (Object)new JerseyJsonLdInterceptor(this.jsonLd, jsonLdMapper, "DSP:2024/1"));
        this.dataServiceRegistry.register(DataService.Builder.newInstance().endpointDescription("dspace:connector").endpointUrl(this.protocolWebhook.url()).build());
        this.versionRegistry.register(DspVersions.V_2024_1);
        this.versionRegistry.register(DspVersions.V_08);
    }

    private ContinuationTokenManager continuationTokenManager(Monitor monitor, String version, JsonLdNamespace namespace) {
        Base64continuationTokenSerDes continuationTokenSerDes = new Base64continuationTokenSerDes(this.transformerRegistry.forContext(version), this.jsonLd);
        return new ContinuationTokenManagerImpl(continuationTokenSerDes, namespace, monitor);
    }

    private void registerValidators(JsonLdNamespace namespace) {
        this.validatorRegistry.register(namespace.toIri("CatalogRequestMessage"), CatalogRequestMessageValidator.instance((CriterionOperatorRegistry)this.criterionOperatorRegistry, (JsonLdNamespace)namespace));
    }
}

