/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.catalog.http.api.decorator;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.catalog.spi.Catalog;
import org.eclipse.edc.connector.controlplane.catalog.spi.CatalogRequestMessage;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.protocol.dsp.catalog.http.api.decorator.Base64continuationTokenSerDes;
import org.eclipse.edc.protocol.dsp.catalog.http.api.decorator.CatalogPaginationResponseDecorator;
import org.eclipse.edc.protocol.dsp.http.spi.message.ContinuationTokenManager;
import org.eclipse.edc.protocol.dsp.http.spi.message.ResponseDecorator;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;

public class ContinuationTokenManagerImpl
implements ContinuationTokenManager {
    private final Base64continuationTokenSerDes continuationTokenSerDes;
    private final JsonLdNamespace namespace;
    private final Monitor monitor;

    public ContinuationTokenManagerImpl(Base64continuationTokenSerDes continuationTokenSerDes, JsonLdNamespace namespace, Monitor monitor) {
        this.continuationTokenSerDes = continuationTokenSerDes;
        this.namespace = namespace;
        this.monitor = monitor;
    }

    public Result<JsonObject> applyQueryFromToken(JsonObject requestMessage, String continuationToken) {
        return (Result)this.continuationTokenSerDes.deserialize(continuationToken).map(query -> Json.createArrayBuilder().add((JsonValue)query)).map(filter -> Json.createObjectBuilder((JsonObject)requestMessage).add(this.namespace.toIri("filter"), filter)).map(JsonObjectBuilder::build);
    }

    public ResponseDecorator<CatalogRequestMessage, Catalog> createResponseDecorator(String requestUrl) {
        return new CatalogPaginationResponseDecorator(requestUrl, this.continuationTokenSerDes, this.monitor);
    }
}

