/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.catalog.http.api;

import org.eclipse.edc.connector.controlplane.catalog.spi.DataService;
import org.eclipse.edc.connector.controlplane.catalog.spi.DataServiceRegistry;
import org.eclipse.edc.connector.controlplane.services.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.protocol.dsp.catalog.http.api.controller.DspCatalogApiController20241;
import org.eclipse.edc.protocol.dsp.catalog.http.api.decorator.Base64continuationTokenSerDes;
import org.eclipse.edc.protocol.dsp.catalog.http.api.decorator.ContinuationTokenManagerImpl;
import org.eclipse.edc.protocol.dsp.catalog.validation.CatalogRequestMessageValidator;
import org.eclipse.edc.protocol.dsp.http.spi.message.ContinuationTokenManager;
import org.eclipse.edc.protocol.dsp.http.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.spi.type.Dsp2024Constants;
import org.eclipse.edc.protocol.spi.DataspaceProfileContextRegistry;
import org.eclipse.edc.protocol.spi.ProtocolWebhook;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.CriterionOperatorRegistry;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.jersey.providers.jsonld.JerseyJsonLdInterceptor;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Dataspace Protocol Catalog v2024/1 Extension")
public class DspCatalogApiV2024Extension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Catalog v2024/1 Extension";
    @Inject
    private WebService webService;
    @Inject
    private CatalogProtocolService service;
    @Inject
    private DataServiceRegistry dataServiceRegistry;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;
    @Inject
    private DspRequestHandler dspRequestHandler;
    @Inject
    private CriterionOperatorRegistry criterionOperatorRegistry;
    @Inject
    private DataspaceProfileContextRegistry dataspaceProfileContextRegistry;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private Monitor monitor;
    @Inject
    private TypeManager typeManager;
    @Inject
    private JsonLd jsonLd;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.registerValidators();
        this.webService.registerResource("protocol", (Object)new DspCatalogApiController20241(this.service, this.dspRequestHandler, this.continuationTokenManager(this.monitor)));
        this.webService.registerDynamicResource("protocol", DspCatalogApiController20241.class, (Object)new JerseyJsonLdInterceptor(this.jsonLd, this.typeManager, "json-ld", "DSP:2024/1"));
    }

    public void prepare() {
        this.registerDataService();
    }

    private void registerDataService() {
        ProtocolWebhook webhook = this.dataspaceProfileContextRegistry.getWebhook("dataspace-protocol-http:2024/1");
        if (webhook != null) {
            this.dataServiceRegistry.register("dataspace-protocol-http:2024/1", DataService.Builder.newInstance().endpointDescription("dspace:connector").endpointUrl(webhook.url()).build());
        }
    }

    private ContinuationTokenManager continuationTokenManager(Monitor monitor) {
        Base64continuationTokenSerDes continuationTokenSerDes = new Base64continuationTokenSerDes(this.transformerRegistry.forContext("dsp-api:2024/1"), this.jsonLd);
        return new ContinuationTokenManagerImpl(continuationTokenSerDes, Dsp2024Constants.DSP_NAMESPACE_V_2024_1, monitor);
    }

    private void registerValidators() {
        this.validatorRegistry.register(Dsp2024Constants.DSP_NAMESPACE_V_2024_1.toIri("CatalogRequestMessage"), CatalogRequestMessageValidator.instance((CriterionOperatorRegistry)this.criterionOperatorRegistry, (JsonLdNamespace)Dsp2024Constants.DSP_NAMESPACE_V_2024_1));
    }
}

