/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.catalog.http.api;

import org.eclipse.edc.connector.controlplane.catalog.spi.DataService;
import org.eclipse.edc.connector.controlplane.catalog.spi.DataServiceRegistry;
import org.eclipse.edc.connector.controlplane.services.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.ProtocolVersionRegistry;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.protocol.dsp.catalog.http.api.controller.DspCatalogApiController08;
import org.eclipse.edc.protocol.dsp.catalog.http.api.decorator.Base64continuationTokenSerDes;
import org.eclipse.edc.protocol.dsp.catalog.http.api.decorator.ContinuationTokenManagerImpl;
import org.eclipse.edc.protocol.dsp.catalog.validation.CatalogRequestMessageValidator;
import org.eclipse.edc.protocol.dsp.http.spi.message.ContinuationTokenManager;
import org.eclipse.edc.protocol.dsp.http.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.spi.type.DspConstants;
import org.eclipse.edc.protocol.dsp.spi.version.DspVersions;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.protocol.ProtocolWebhook;
import org.eclipse.edc.spi.protocol.ProtocolWebhookRegistry;
import org.eclipse.edc.spi.query.CriterionOperatorRegistry;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.jersey.providers.jsonld.JerseyJsonLdInterceptor;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Dataspace Protocol Catalog v08 Extension")
public class DspCatalogApiV08Extension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Catalog v08 Extension";
    @Inject
    private WebService webService;
    @Inject
    private ProtocolWebhookRegistry protocolWebhookRegistry;
    @Inject
    private CatalogProtocolService service;
    @Inject
    private DataServiceRegistry dataServiceRegistry;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;
    @Inject
    private DspRequestHandler dspRequestHandler;
    @Inject
    private CriterionOperatorRegistry criterionOperatorRegistry;
    @Inject
    private ProtocolVersionRegistry versionRegistry;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private Monitor monitor;
    @Inject
    private TypeManager typeManager;
    @Inject
    private JsonLd jsonLd;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.registerValidators();
        this.webService.registerResource("protocol", (Object)new DspCatalogApiController08(this.service, this.dspRequestHandler, this.continuationTokenManager(this.monitor)));
        this.webService.registerDynamicResource("protocol", DspCatalogApiController08.class, (Object)new JerseyJsonLdInterceptor(this.jsonLd, this.typeManager, "json-ld", "DSP:v0.8"));
        this.versionRegistry.register(DspVersions.V_08);
    }

    public void prepare() {
        this.registerDataService();
    }

    private void registerDataService() {
        ProtocolWebhook webhook = this.protocolWebhookRegistry.resolve("dataspace-protocol-http");
        if (webhook != null) {
            this.dataServiceRegistry.register("dataspace-protocol-http", DataService.Builder.newInstance().endpointDescription("dspace:connector").endpointUrl(webhook.url()).build());
        }
    }

    private ContinuationTokenManager continuationTokenManager(Monitor monitor) {
        Base64continuationTokenSerDes continuationTokenSerDes = new Base64continuationTokenSerDes(this.transformerRegistry.forContext("dsp-api:v0.8"), this.jsonLd);
        return new ContinuationTokenManagerImpl(continuationTokenSerDes, DspConstants.DSP_NAMESPACE_V_08, monitor);
    }

    private void registerValidators() {
        this.validatorRegistry.register(DspConstants.DSP_NAMESPACE_V_08.toIri("CatalogRequestMessage"), CatalogRequestMessageValidator.instance((CriterionOperatorRegistry)this.criterionOperatorRegistry, (JsonLdNamespace)DspConstants.DSP_NAMESPACE_V_08));
    }
}

